/*
 * Created on Jun 5, 2005
 *
 */
package com.jofti.query.namespace;

/**
 *
 *
 * A utility class to enable simple queries to be done easily. The Query matches everything larger than the 
 * value passed in for that particular field. The optional inclusive flag allows the behaviour to be either >= or just >.
 * <p>
 * All nameSpace queries must provide a correct namespace type for the implementation. Some nameSPaces 
 * are hierachical and so the search will use the nameSpace as starting point. Others are flat and so there is no 
 * traversal step.
 * <p>
 *  This query acannot be combined with any other. iF you want to construct more complex queries use the @link com.jofti.query.Query class.
 * <p>
 * @author Steve Woodcock
 */
public class MatchNSLargerQuery extends MatchNSRangeQuery {
	
	
	/**
	 * Construct a query supplying the classname of the object type to be returned, the namespace 
	 * under which to start the search. The field to be queried and the value to be used. 
	 * <p>
	 * The field type in the object and the value must be of the same type.
	 * <p>
	 * It is assumed that the search is inclusive.
	 * <p>
	 * An example usage (for JBossCache) would be:
	 * <p>
	 * new MatchNSLargerQuery("org.package.Myclass", "/test", "myProperty" ,"some value");
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param nameSpace - the name space to be searched.
	 * @param propertyName - the field name to use
	 * @param value - the value that is used as the search value.
	 */
	public MatchNSLargerQuery(Class className, Object nameSpace,String propertyName, Comparable value){
		this(className,nameSpace,propertyName,value,null);
	}
	public MatchNSLargerQuery(Class className, Object nameSpace,String propertyName, Comparable value,Object alias){
		super(className,nameSpace,propertyName,value,null,alias);
	}
	
	public MatchNSLargerQuery(String className, Object nameSpace,String propertyName, Comparable value){
		this(className,nameSpace,propertyName,value,null);
	}
	public MatchNSLargerQuery(String className, Object nameSpace,String propertyName, Comparable value,Object alias){
		super(className,nameSpace,propertyName,value,null,alias);
	}
	/**
	 * Construct a query supplying the classname of the object type to be returned, the namespace 
	 * under which to start the search. The field to be queried and the value to be used. The method
	 * also allows control of whether the query is inclusive of the value or not.
	 * <p>
	 * The field type in the object and the value must be of the same type.
	 * <p>
	 * An example usage (for JBossCache) would be:
	 * <p>
	 * new MatchNSLargerQuery("org.package.Myclass", "/test", "myProperty" ,"some value");
	 * <p>
	 * @param className - the class of object to be returned.
	 * @param nameSpace - the name space to be searched.
	 * @param propertyName - the field name to use
	 * @param value - the value that is used as the search value.
	 * @param inclusive - indicates if the value is to be inclusive in range.
	 */
	public MatchNSLargerQuery(Class className, Object nameSpace, String propertyName, Comparable value, boolean inclusive){
		this(className,nameSpace,propertyName,value, inclusive,null);
	}
	public MatchNSLargerQuery(Class className, Object nameSpace, String propertyName, Comparable value, boolean inclusive,Object alias){
		super(className,nameSpace,propertyName,value,null,inclusive,alias);
	}
	
	public MatchNSLargerQuery(String className, Object nameSpace, String propertyName, Comparable value, boolean inclusive){
		this(className,nameSpace,propertyName,value,inclusive,null);
	}
	public MatchNSLargerQuery(String className, Object nameSpace, String propertyName, Comparable value, boolean inclusive,Object alias){
		super(className,nameSpace,propertyName,value,null,inclusive,alias);
	}
	
	/**
	 * Construct a query supplying the value to be searched against and the namespace 
	 * under which to start the search. This is a convenience method for classes (such as String,Integer etc)
	 * that have no property value as such. Instead the value is the class type.
	 * <p>
	 * 
	 * An example usage (for JBossCache) would be:
	 * <p>
	 * new MatchNSLargerQuery( "/test","some value",true);
	 * <p>
	 * This is so you do not have to use the methods above in the manner of
	 * <p>
	 * new MatchNSLargerQuery("java.lang.String", "/test", null ,"some value"); 
	 * <p>

	 * @param nameSpace - the name space to be searched.
	 * @param value - the value that is used as the search value.
	 * @param inclusive - indicates if the value is to be inclusive in range.
	 */
	public MatchNSLargerQuery(Object nameSpace, Comparable value,boolean inclusive){
		super(nameSpace,value,null,inclusive,null);
	}
	
	public MatchNSLargerQuery(Object nameSpace, Comparable value,boolean inclusive,Object alias){
		super(nameSpace,value,null,inclusive,alias);
	}
	
}
