
package com.jofti.store;

import com.jofti.exception.JoftiException;

import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;

/**
 * Responsible for allocating new Buffers that are used to copy data to and from files. 
 * 
 * @author xenephon
 */
public class BufferManager {


	/**
	 * 
	 */
	LinkedBlockingQueue freeQueue = null;

	//block size for buffer
	private int blockSize = 0;

	//maximum number of buffers to cache
	private int maxBuffers = 100;

	// initial number of buffers to create
	private int bufferNumber = 10;
	
	// count for new buffers created
	private long newBuffers =0;

	private long accesses=0;

	private long releases=0;
	
	public BufferManager() {
	}

	public void init(int blockSize, int maxBuffers, int bufferNumber)
			throws JoftiException 
	{
		// allocate all the free buffers to the freeQueue
		this.blockSize = blockSize;
		this.maxBuffers = maxBuffers;
		this.bufferNumber = bufferNumber;

		// set up the buffer pool
		freeQueue = new LinkedBlockingQueue(maxBuffers);

		for (int i = 0; i < bufferNumber; i++) {
			BlockBuffer buf = new BlockBuffer();
			buf.init(blockSize);
			freeQueue.add(buf);
		}

	}


	/**
	 * Obtains a BlockBuffer from the buffer pool.
	 * 
	 * @param holder
	 * @return
	 * @throws JoftiException
	 */
	public BlockBuffer acquireBuffer(FilePositionHolder holder)
			throws JoftiException {

		++accesses;
		
		BlockBuffer buf = (BlockBuffer) freeQueue.poll();
		
		// we must be out of buffers so we can create one
		if (buf == null) {
			// create a new buffer
			buf = new BlockBuffer();
			buf.init(blockSize);
			++newBuffers;

		}
		buf.setPositionHolder(holder);

		return buf;
	}

	/**
	 * releases a buffer into the freeQueue
	 * @param buffer LogBuffer to be released
	 */
	public void releaseBuffer(BlockBuffer buffer) {
		
		++releases;
		buffer.reset();

		// if the offer does not work then we do not care
		freeQueue.offer(buffer);

	}
	
	
	
	
}