/*
 * Created on 18-Mar-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.store;

import java.nio.ByteBuffer;
import java.util.Arrays;

import com.jofti.btree.IPage;
import com.jofti.btree.LeafNodeEntry;
import com.jofti.core.IStoreManager;


/**
 * @author xenephon
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CachedPage implements IPage {

	/**
	 * @param pointers
	 * @param buf
	 * @param manager
	 */

	LeafNodeEntry[] entries =null;
	IPage page =null;
	int references=0;
	
	public CachedPage( IPage page) {
		this.page =page;
		
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#getEntry(int)
	 */
	
	
	public LeafNodeEntry getEntry(int position) {
		LeafNodeEntry entry =null;
		
		entry = entries[position];
		if (entry ==null){
			entry = page.getEntry(position);
			
			entries[position]=entry;
		}
		return entry;
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#setEntry(int, com.jofti.btree.StorableLeafNodeEntry)
	 */
	public void setEntry(int position, LeafNodeEntry entry) {
		
		
		System.arraycopy(entries,position,entries,position+1,(entries.length-1) -position);
		entries[position]=entry;
		
		page.setEntry(position, entry);
		
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#removeEntry(int)
	 */
	public void removeEntry(int position) {
		
		Arrays.fill(entries,null);
		
		page.removeEntry(position);
		
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#updateEntry(int, com.jofti.btree.StorableLeafNodeEntry)
	 */
	public void updateEntry(int location, LeafNodeEntry entry) {
		entries[location]=entry;
		
		page.updateEntry(location, entry);
		
	}
	
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#copyBuffer(java.nio.ByteBuffer)
	 */
	public ByteBuffer copyBuffer(ByteBuffer newBuf) {
		return page.copyBuffer(newBuf);
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#reset()
	 */
	public void reset() {
		for (int i=0;i<entries.length;i++){
			entries[i]=null;
		}
		page.reset();
		
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#getBuffer()
	 */
	public ByteBuffer getBuffer() {

		return page.getBuffer();
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#getPointers()
	 */
	public int[] getPointers() {

		return page.getPointers();
	}
	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#setManager(com.jofti.core.IStoreManager)
	 */
	public void setManager(IStoreManager manager) {
		page.setManager(manager);
		
	}
	
	public synchronized void acquireReference(){
		++references;
	}

	public synchronized void releaseReference(){
		--references;
	}
	
	public synchronized boolean hasReferences(){
		return references>0;
	}
}
