
package com.jofti.store;

import com.jofti.core.IStoreManager;
import com.jofti.exception.JoftiException;

import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;

/**
 * Pool of Externalizable helpers to obtain and release helpers to and from.
 * <p>
 * @author xenephon
 *
 */
public class HelperManager {

	LinkedBlockingQueue freeQueue = null;
	IStoreManager manager =null;
	int nodeSize;
	int blockSize;
	/**
	 * 
	 */
	public HelperManager() {
	}
	
	public void init(int helperNumber,int blockSize, int nodeSize,IStoreManager manager ) throws JoftiException{
//		 set up the buffer pool
		freeQueue = new LinkedBlockingQueue(helperNumber);
		this.manager =null;
		this.blockSize = blockSize;
		this.nodeSize =nodeSize;
		// set up the helpers
		for (int i=0;i<helperNumber;i++){
			ExternalisableHelper helper = new ExternalisableHelper();
			helper.init(nodeSize, blockSize,manager);
			freeQueue.add(helper);
		}
	}

	
	public ExternalisableHelper acquireHelper()
	throws JoftiException 
	{

		ExternalisableHelper helper = null;

		helper =(ExternalisableHelper) freeQueue.poll();
		if (helper == null){
			helper = new ExternalisableHelper();
			helper.init(nodeSize, blockSize,manager);
		}
		return helper;
	}

	public void releaseHelper(ExternalisableHelper helper)
	{
			freeQueue.offer(helper);
	}
}
