/*
 * Created on 14-Mar-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.jofti.store;

import java.nio.ByteBuffer;
import java.util.Arrays;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.btree.IPage;
import com.jofti.btree.LeafNodeEntry;
import com.jofti.core.IStoreManager;
import com.jofti.exception.JoftiException;

/**
 * @author xenephon
 *
 */
  public class Page implements Cloneable, IPage{
	
      private static Log log =  LogFactory.getLog(Page.class);
      
	public int[] pointers =null;
	public ByteBuffer buf = null;
	IStoreManager manager =null;
	IEntrySerializer serializer=null;
	int bufSize =0;
	
	int reference =0;
	
	public Page(int[] pointers, ByteBuffer buf, IStoreManager manager, IEntrySerializer serializer){
		this.pointers = pointers;
		this.buf =buf;
		bufSize = buf.capacity();
		this.manager = manager;
		this.serializer = serializer;
	}
	
	
	
	public  LeafNodeEntry getEntry(int position){
		LeafNodeEntry obj =null;
		
		

			
		if (position >= pointers.length){
			log.warn("error in page  for position "+ position);
			return null;
		}else{
			int pos  = pointers[position];
			if (pos != -1){
				ByteBuffer tempBuffer = buf.duplicate();
				tempBuffer.position(pos);
				tempBuffer.getInt();
				try{
				obj= serializer.convertFromStorage(tempBuffer);
				} catch (Throwable e){
					e.printStackTrace();
					throw new RuntimeException(e);
				}
			//	nodeEntries[position]=obj;
			}else{
                log.warn("expected entry in page found -1 at pos "+ position);
				
				for (int i=0;i<position;i++){
                    log.warn(i + "["+pointers[i] + "],");
				}
				throw new RuntimeException("expected entry found -1 "+ position +" "+ this);
			}
			if (obj ==null){
                log.warn("returning null for "+ position + " on buf "+ buf);
			}
			return obj;
		}
	}
	
	public void setEntry(int position, LeafNodeEntry entry){
		
		byte[] bytes = null;
		try {
			bytes = serializer.convertForStorage(entry);
		} catch(JoftiException e){
			throw new RuntimeException("unable to convert entry to bytes "+ entry,e);
		}
		//see if we can fit this into the buffer
		if (buf.capacity() < buf.limit() + (bytes.length+4)){
			// we need to reallocate the buffer
			ByteBuffer temp = ByteBuffer.allocate((int)(buf.capacity() *1.5));
			buf.position(0);
			temp.put(buf);
			temp.flip();
            ByteBuffer oldBuf =buf;
			//temp.limit(temp.position());
			buf = temp;
			log.info("new buffer assigned in page "+ buf + " " + oldBuf);
		}
	
		
		
		
		// find out where we put this
		int pos = pointers[position];

		
		
		//length of insert
		int length = 4 + bytes.length;
		
		// first insert - or at end - 
		if (pos == -1 ){
			//we can just add at end
			if (position ==0){
				pos =0;
			}else{
				pos = buf.limit();
			}
		//are we adding at end
			//reset the limt
			buf.limit(buf.limit()+length);
			buf.position(pos);
			buf.putInt(bytes.length);
			buf.put(bytes);
			//new limit and position should match
			
		}else{
			//set where we are going to put the new data
			buf.position(pos);
			buf.mark();
			// create a copy - not a copy of the backing data
			ByteBuffer copy = buf.duplicate();
			// reset limit on buffer so we do not overflow
			buf.limit(buf.capacity());
			//set the position we are writing to
			buf.position(buf.position() + length);
			// copy the moved data
			try {
			    buf.put(copy);
			} catch (Throwable t){
				log.warn("inserting failure for " + buf,t);
                throw new RuntimeException("inserting failure for " + buf,t);
			}
			// reset the limt to the current position
			buf.limit(buf.position());
	
			
			// reset back to the previous mark
			buf.reset();
			
			//write the data
			buf.putInt(bytes.length);
			buf.put(bytes);
		}

			// reset the pointers
			if (pointers[position] != -1){
				System.arraycopy(pointers,position,pointers,position+1,(pointers.length-1) -position);
	
				for (int i=position+1;i<pointers.length && pointers[i]!=-1;i++){
					pointers[i]=pointers[i]+ length;
				}
			}
			pointers[position]=pos;


		
	}
	
	
	

	
	public  void removeEntry(int position){
		
		if (position >= pointers.length || pointers[position] ==-1){
			return;
		}else{

			int pos  = pointers[position];	
			// set up the start of the next entry
			int overWriteStart =0;
			// if it is not  the last entry then use the next entry
			if (position != pointers.length-1){
				overWriteStart = pointers[position+1];
			}
			if (overWriteStart ==-1 || position == pointers.length-1){
				//we can just truncate using the limit
				buf.position(pos);
				buf.limit(pos);
				pointers[position]=-1;
			}else{
			// set the position of the buffer to the pos
				buf.position(pos);
				
				// mark where the write is going to be put
				buf.mark();
				// duplicate the buffer
				ByteBuffer temp = buf.duplicate();
				//get the size of the array plus the 
				int length = temp.getInt()+4;
				// set the pos for the overwriteStart
				temp.position(overWriteStart);
				
				// reset back to the mark
				buf.reset();
				// put the bytes in
				try {
				    buf.put(temp);
				} catch (Exception e){
					log.warn("problem moving buffer posoition ",e );

				}
				
				// reset the limt
				buf.limit(buf.position());
				

				
				//copy them back over the previous entries
				int start =position+1;
				int arrayLength = (pointers.length) -(position+1);
				System.arraycopy(pointers,start,pointers,position,arrayLength);
				
				// reset the last one to -1 - sort of like bit shift

				pointers[pointers.length-1]=-1;
					
				
				
				// take off the removed entries
				for (int i=position;i<pointers.length && pointers[i]!=-1;i++){
					if (position == pointers.length-1 || pointers[i]==-1){
						pointers[i]=-1;
					}else{
						pointers[i]=pointers[i]- length;
					}
				}
				}
		
			
		}
	}
	
	public  void updateEntry(int location, LeafNodeEntry entry){
		removeEntry(location);
		setEntry(location, entry);
	}
	
	
	
	public  ByteBuffer copyBuffer(ByteBuffer newBuf){
		
		buf.rewind();
	    newBuf.clear();
	    newBuf.put(buf);
	    newBuf.flip(); 
	    return newBuf;
	}
	
	public void reset(){
		Arrays.fill(pointers,-1);
		
		buf.clear();
		buf.flip();
		
	}



	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#getBuffer()
	 */
	public ByteBuffer getBuffer() {
		
		return buf;
	}



	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#getPointers()
	 */
	public int[] getPointers() {
		return pointers;
	}



	/* (non-Javadoc)
	 * @see com.jofti.store.IPage#setManager(com.jofti.core.IStoreManager)
	 */
	public void setManager(IStoreManager manager) {
		this.manager = manager;
		
	}
	
}

