package com.jofti.store;

import java.nio.ByteBuffer;

import com.jofti.btree.BTree;
import com.jofti.btree.IPage;
import com.jofti.core.IStoreManager;
import com.jofti.exception.JoftiException;

import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;

/**
 * @author xenephon
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class PageManager {

	/**
	 *  
	 */
	/**
	 *  
	 */
	LinkedBlockingQueue bufQueue = null;

	LinkedBlockingQueue largeBufQueue = null;

	LinkedBlockingQueue pageQueue = null;

	private int blockSize = 0;

	private int maxPages = 100;

	private int pageNumber = 10;

	long waitingTime = 0;

	private long newPages = 0;

	long accesses = 0;

	long newBuffers=0;
	
	long bufferAccesses=0;
	
	
	
	IStoreManager manager = null;
	IEntrySerializer serializer =null;

	public PageManager() {
		super();
	}

	public void init(int blockSize, int maxPages, int pageNumber,
			IStoreManager manager, IEntrySerializer serializer) throws JoftiException 
	{
		// allocate all the free buffers to the freeQueue
		this.blockSize = blockSize;
		this.maxPages = maxPages;
		this.manager = manager;
		this.serializer = serializer;

		// set up the buffer pools
		bufQueue = new LinkedBlockingQueue(maxPages);
		largeBufQueue = new LinkedBlockingQueue(maxPages);
		pageQueue = new LinkedBlockingQueue(maxPages);

		//allocate pages
		for (int i = 0; i < pageNumber; i++) {
			int[] arr = new int[BTree.getMaxNodeSize()];
			for (int j = 0; j < arr.length; j++) {
				arr[j] = -1;
			}
			ByteBuffer buf = ByteBuffer.allocate(blockSize);
			buf.flip();
			Page page = new Page(arr, buf, manager,serializer);
			pageQueue.add(page);
		}

		//allocate normal buffers
		for (int i = 0; i < pageNumber; i++) {
			ByteBuffer buf = ByteBuffer.allocate(blockSize);
			buf.flip();
			bufQueue.add(buf);
		}

		//allocate large buffers
		for (int i = 0; i < pageNumber; i++) {
			ByteBuffer buf = ByteBuffer.allocate(blockSize * 2);
			buf.flip();
			largeBufQueue.add(buf);
		}
		this.pageNumber = pageNumber;

	}

	
	public IPage acquirePage(int size) throws JoftiException 
	{

		accesses++;

		Page page = (Page) pageQueue.poll();

		// we must be out of buffers so we can create one
		if (page == null) {

			++newPages;
			// create a new buffer and nset up the pointers
			int[] arr = new int[BTree.getMaxNodeSize()];
			for (int j = 0; j < arr.length; j++) {
				arr[j] = -1;
			}
			
			page = new Page(arr, acquireBuffer(size), manager,serializer);

		} else {
			if ((size > blockSize && page.buf.capacity() == blockSize)
					|| (size <= blockSize && page.buf.capacity() > blockSize)) {
				// offer the old buffer back to the pool
				bufQueue.offer(page.buf);
				page.buf = acquireBuffer(size);
			}
		}
		return page;
	}

	/**
	 * releases a buffer into the freeQueue
	 * 
	 * @param buffer
	 *            LogBuffer to be released
	 */
	public void releasePage(IPage page) {

		page.reset();

		
		if (!pageQueue.offer(page)){
			releaseBuffer(page.getBuffer());
		}

	}

	public ByteBuffer acquireBuffer(int size) {
		++bufferAccesses;
		ByteBuffer buf = null;
		if (size > blockSize) {
			buf = (ByteBuffer) largeBufQueue.poll();
			if (buf == null || size > buf.capacity()) {
				++newBuffers;
				buf = ByteBuffer.allocate(size);
				buf.flip();
			}

		} else {
			buf = (ByteBuffer) bufQueue.poll();
			if (buf == null) {
				++newBuffers;
				buf = ByteBuffer.allocate(blockSize);
				buf.flip();
			}
		}
		return buf;
	}

	public void releaseBuffer(ByteBuffer buf) {
		buf.clear();
		buf.flip();
		if (buf.capacity() <= blockSize) {
			bufQueue.offer(buf);
		} else {
			largeBufQueue.offer(buf);
		}
	}

}