package com.jofti.store;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.btree.IPage;
import com.jofti.core.IStoreKey;
import com.jofti.exception.JoftiException;

public class PassThroughStoreManager extends AbstractStoreManager
{

    private static Log log = LogFactory.getLog(AbstractStoreManager.class);

    public void init(Properties properties) throws JoftiException
    {

        if (log.isInfoEnabled()) {
            log.info("Initialising PassThrough store manager");
        }
        super.init(properties);
        if (log.isInfoEnabled()) {
            log.info("Initialised PassThrough store manager");
        }
    }

    public void releasePage(IStoreKey key, IPage page)
    {
        if (page != null) {
            pageManager.releasePage(page);
        }
    }

    public IStoreKey store(IStoreKey key, IPage page) throws JoftiException
    {
        // RecordWrapper wrapper = new RecordWrapper(key,obj,true);
        FilePositionHolder[] array = allocatePositions(key.getFilePositions(),
                page.getBuffer().limit());
        key.setFilePositions(array);

        key = doStore(key, page.getBuffer());
        releasePage(key, page);

        return key;
    }

    public StoreWrapper retrieve(IStoreKey key) throws JoftiException
    {

        return new StoreWrapper(key, doRetrieve(key));

    }

    public void remove(IStoreKey key, IPage page) throws JoftiException
    {
        releasePage(key, page);
        doRemove(key);

    }

    /* (non-Javadoc)
     * @see com.jofti.store.AbstractStoreManager#getNewPage(int)
     */
    protected IPage getNewPage(int size)
    {
        return doGetNewPage(size);
    }

    public void removeAll() throws JoftiException
    {
        doRemoveAll();
        
    }

}
