package com.jofti.store;

import java.io.Serializable;

import com.jofti.core.IStoreKey;

public class StoreKey implements IStoreKey, Cloneable,Serializable {

	/**
     * 
     */
    private static final long serialVersionUID = 6668445940104260505L;
    
    long id =0;
	private volatile int hashCode =0;
	FilePositionHolder[] filePositions =null;
    int size=0;
    int number =0;
	
	public boolean newKey =false;
	
	
	public StoreKey(){
		
	}
	
	public StoreKey(long id){
		this.id= id;
	}
	
	



	
	public boolean equals(Object obj){
		if (obj instanceof IStoreKey) {
			IStoreKey temp = (IStoreKey) obj;
			
			return temp.getId() == id;
	
		}
		return false;
	}
	
	
	
	public int hashCode(){
		if (hashCode ==0){
			hashCode = (int) (id ^ id>>32) ;
		}
		return hashCode;
	}

	
	
	public String toString(){
		return "ID:"+id + " size:"+size + " new:"+newKey;
	}

	/* (non-Javadoc)
	 * @see com.jofti.core.IStoreKey#getNextPositions()
	 */
	public FilePositionHolder[] getFilePositions() {
		return filePositions;
	}
	public void setFilePositions(FilePositionHolder[] filePositions) {
		this.filePositions = filePositions;
	}

    public boolean isNewKey()
    {
        return newKey;
    }

    public void setNewKey(boolean newKey)
    {
        this.newKey = newKey;
        
    }

    /**
     * @return Returns the size.
     */
    public int getSize()
    {
        return size;
    }

    /**
     * @param size The size to set.
     */
    public void setSize(int size)
    {
        this.size = size;
    }
    
    public Object clone(){
   	StoreKey key = new StoreKey();
    	key.id = id;
    	if (filePositions != null){
    		key.filePositions = (FilePositionHolder[])filePositions.clone();
    	}
    	key.size =size;
    	key.newKey = newKey;
    	key.number =number;
    	return key;
    	
    }

	/* (non-Javadoc)
	 * @see com.jofti.core.IStoreKey#getId()
	 */
	public long getId() {
		return id;
	}
	public int getNumber() {
		return number;
	}
	public void setNumber(int number) {
		this.number = number;
	}
}
