/*
 * Created on 24-Jul-2005
 *

 */
package com.jofti.tree;



import java.util.Map;
import java.util.Stack;

import com.jofti.btree.ValueObject;
import com.jofti.core.INameSpaceAware;
import com.jofti.core.IParsedQuery;
import com.jofti.core.IPredicate;
import com.jofti.exception.JoftiException;
import com.jofti.parser.AttributeValueParser;
import com.jofti.parser.CommonLexerTokenTypes;
import com.jofti.parser.Operator;
import com.jofti.parser.StackPredicate;
import com.jofti.util.FastStack;
import com.jofti.util.ObjectProcedureAdapter;
import com.jofti.util.OpenHashMap;

/**
 * @author Steve Woodcock
 *
 
 */
public abstract class AbstractMatchingEngine implements MatchingEngine {


	

	// move these to be parser constants at some point
	protected static final int OR = CommonLexerTokenTypes.OR;
	protected static final int AND = CommonLexerTokenTypes.AND;
	
	
	protected AttributeValueParser attributeValueParser = new AttributeValueParser();;
	

	
	
    
    
protected Map addAllOpen(final OpenHashMap large, final OpenHashMap smaller){
      //  large.ensureCapacity(large.size()+smaller.size());
        smaller.forEachPair( new ObjectProcedureAdapter(){
            public boolean apply(Object key, Object value){
                if (!large.containsKey(key)){
                    large.put(key, value);
                }
                return true;
            }
        });

        return large;
    }
    
    
protected Map retainAllOpen(final OpenHashMap large, final OpenHashMap smaller){
        
        smaller.forEachPair( new ObjectProcedureAdapter(){
            public boolean apply(Object key, Object value){
                if (!large.containsKey(key)){
                    smaller.remove(key);
                }
                return true;
            }
        });

        return smaller;
    }

	protected Map andResults(Map map1, Map map2){
		if (map1.size() > map2.size()){
			return retainAllOpen((OpenHashMap)map1, (OpenHashMap)map2);
		}else{
			return retainAllOpen((OpenHashMap)map2, (OpenHashMap)map1);
		}
	}

	
	protected Map orResults(Map map1, Map map2){
			if (map1.size() > map2.size()){
				return addAllOpen((OpenHashMap)map1, (OpenHashMap)map2);
			}else{
				return addAllOpen((OpenHashMap)map2, (OpenHashMap)map1);
			}
		}
		
	// we use a hash join here as we assume the results all fit into main memory
		protected Map resultJunction(Map map1, Operator op, Map map2){
            
		
				switch (op.getOperator()) { 
					case OR:
						if (map1.size() ==0) {
							return map2;
						}else if (map2.size() ==0){
							return map1;
						}
						return orResults(map1,map2);
					case AND:
						if ((map1.size() ==0 ||  map2.size() ==0)){
							return new OpenHashMap(1);
						}
						return andResults(map1,map2);
					default:
						return new OpenHashMap(1);
				}
			
		}
		
		
		protected Map processPredicates(Stack predicates, Class className, Object nameSpace, Map aliasMap,TreeIndex index, Map namedParameters) throws JoftiException{
			
			Map firstResults = null;
			Map returnResults =null;
			IPredicate first =null;
			
             FastStack predicateStack = null;
             if (predicates.size() == 1){
             	first = (IPredicate)predicates.peek();
             }
             else{
             	predicateStack = new FastStack();
             	 predicateStack.addAll(predicates);
             	 first = (IPredicate)predicateStack.pop();
             }
            
  
			
			if (first.getType() ==1){
				firstResults = processPredicates(((StackPredicate)first).getPredicateStack(), className, nameSpace, aliasMap,index, namedParameters);
			}else{
				firstResults = runPredicate(first, className, nameSpace,aliasMap,index, namedParameters);
			}
			
		
			if (predicateStack == null || predicateStack.size() ==0){
				returnResults = firstResults;
			}else if (predicateStack.size() %2 == 0 && predicateStack.size() != 0){
				returnResults = processRemainder(firstResults, predicateStack, className, nameSpace,aliasMap, index, namedParameters);
			}else if (predicateStack.size() %2 == 1){
				throw new JoftiException("we seem to have a hanging operator or predicate " );
			}
				// we do not care
			return returnResults;
			
		
		}
		
		protected Map processQuery(IParsedQuery query,TreeIndex index) throws JoftiException{
			
	
			// then get the predicates
			
			Stack predicates = query.getPredicates();
			
			Object nameSpace = null;
			if (((INameSpaceAware)query).getNameSpace() != null){
				nameSpace =((INameSpaceAware)query).getNameSpace();
			}
			// wif stack is empty then we need to do a range query for the whole entry
			
			 if (predicates.isEmpty()){
              	
              	// we need to get all results for the index and then merge them together as ors
             // 	return processNoPredicates(query.getResultFieldsMap(), nameSpace, index);
			 	throw new JoftiException("At least one predicate in where clause is required in Query");
              }
			// first one should always be a predicate
			Map results = processPredicates(predicates, query.getClassName(), nameSpace,query.getAliasMap(),index, query.getNamedValueMap());
			
			
			return results;
		}
		
		

		
		protected Map processRemainder(Map results, FastStack predicates, Class className,Object nameSpace, Map aliasMap,TreeIndex index, Map namedParameters ) throws JoftiException{
			while (predicates.size() %2 == 0 && predicates.size() != 0){
				Operator op= (Operator)predicates.pop();
				 IPredicate second= (IPredicate) predicates.pop();
				 Map secondResults =null;
				if (second.getType() ==1){
					secondResults = processPredicates(((StackPredicate)second).getPredicateStack(), className, nameSpace, aliasMap,index,namedParameters);
				}else{
					secondResults = runPredicate(second, className, nameSpace,aliasMap,index, namedParameters);
				}
				results = resultJunction(results, op, secondResults);
			}
			return results;
		}
		
		protected Map runPredicate(IPredicate pred, Class className, Object nameSpace, Map aliasMap,TreeIndex index, Map namedParameters) throws JoftiException{
			Class name =null;
			Object tempAlias =null;
			if (pred.getAlias() != null){
				tempAlias =name = (Class)aliasMap.get(pred.getAlias());
			}else{
				name = className;
			}
			String attribute =null;
			if (!(AttributeValueParser.VALUE.equalsIgnoreCase(pred.getField())) && 
					(!index.getIntrospector().getPrimitiveClasses().contains(name.toString()))){
				attribute = pred.getField();
			}
			

			try {
				
				return performQuery(pred.getOperator(), name, nameSpace, attribute, pred.getValue(), index, namedParameters, tempAlias);	
			} catch (Throwable t){
				if (t instanceof JoftiException){
					throw (JoftiException)t;
				}else{
					throw new JoftiException(t);
				}
			}
		}

		// wraps null value
		protected Comparable wrapNull(Comparable value){
			if (value == null){
				return ValueObject.MIN_COMAPARBLE_VALUE;
			}
			return value;
		}

        /**
         * @param pred
         * @param index
         * @param name
         * @param attribute
         * @return
         * @throws JoftiException
         */
		
	
		
		// construct a value from the supplied parameter map
	
		
		
	
		
	
        
     
        
        protected void testNull(Object obj) throws JoftiException{
        	if (obj == null){
        		throw new JoftiException("value null not permitted in query");
        	}
        }
		protected abstract Map performQuery(int operator, Class className, Object nameSpace,String attribute, Object value, TreeIndex index, Map namedParameters, Object alias) throws JoftiException;

}
