/*
 * Created on 13-May-2005
 *
 */
package com.jofti.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.api.NameSpaceKey;
import com.jofti.btree.BTOperations;
import com.jofti.btree.BTree;
import com.jofti.cache.adapter.NameSpaceWrapper;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.util.ObjectProcedureAdapter;
import com.jofti.util.OpenHashMap;

/**
 * The class that the TreeIndex delegates to for operations involving NameSpace caches.<p>
 * 
 * 
 * @author Steve Woodcock (steve@jofti.com)
 *
 */
public class NameSpaceTreeOperationAdapter extends TreeOperationAdapter{


	public NameSpaceTreeOperationAdapter(){
	}
	
	private static Log log =  LogFactory.getLog(NameSpaceTreeOperationAdapter.class);
	
	
  /* (non-Javadoc)
 * @see com.jofti.tree.TreeOperationAdapter#contains(java.lang.Comparable, com.jofti.btree.BTree, com.jofti.introspect.ClassIntrospector)
 */
public boolean contains(Comparable key,BTree tree, ClassIntrospector parser)throws JoftiException{
   	 return BTOperations.contains(tree, key, parser.getKeyDimension(((NameSpaceKey)key).getKey().getClass()));
   }
	  
	/* (non-Javadoc)
	 * @see com.jofti.tree.TreeOperationAdapter#insert(java.lang.Comparable, java.lang.Object, com.jofti.btree.BTree, com.jofti.introspect.ClassIntrospector)
	 */
	public void insert(Comparable key, Object value, BTree tree,ClassIntrospector parser) throws IllegalArgumentException, JoftiException{
        // first is it the right type
    	
		Map attributes = parser.getAttributeValues(value);
		 if (attributes == null || attributes.isEmpty()){
			 if(log.isDebugEnabled()){         
		         	log.debug("No attributes found for '" + key +"' ignoring in index");
		      } 
			 return;
		 }
		 
         List addedObjects = new ArrayList();
	         NameSpaceKey tempKey = (NameSpaceKey)key;
	
	         // we index the key first
	         if(log.isDebugEnabled()){         
	         	log.debug("Attempting to insert name space '" + tempKey +"'");
	         }
	         BTOperations.insertValue(tree,  key,new NameSpaceWrapper(tempKey.getNameSpace()),parser.getKeyDimension(NameSpaceWrapper.class));

            // first is it the right type

    		 try {
    		 	
    		 	 if(log.isDebugEnabled()){         
    	         	log.debug("Attempting to insert key '" + key +"'");
    	         }
    		 	  // we index the key first
    	         BTOperations.insertKeyValue(tree, key, attributes,parser.getKeyDimension(((NameSpaceKey)key).getClass()));
    	         addedObjects.add(key);
    	         if(log.isDebugEnabled()){         
    	         	log.debug("inserted key '" + key +"'");
    	         }
    	         
    		 	 treeInsert(key,tree,attributes,addedObjects);
    		 	 
    		 } catch (JoftiException e){
             	log.error("Error encountered - removing indexed objects " + addedObjects,e);
        		removeIndexedValues(key,addedObjects,tree,parser );
        	}
        
    }    
	 /* (non-Javadoc)
	 * @see com.jofti.tree.TreeOperationAdapter#removeByKey(java.lang.Comparable, com.jofti.btree.BTree, com.jofti.introspect.ClassIntrospector)
	 */
	public void removeByKey(Comparable value, BTree tree, ClassIntrospector parser) throws JoftiException
	    {
		  

		//	Collection matchingValues = BTOperations.getKeyAttributes(tree,value,parser.getKeyDimension(((NameSpaceKey)value).getKey().getClass()));
			Collection matchingValues = BTOperations.getKeyAttributes(tree,value,parser.getKeyDimension(((NameSpaceKey)value).getClass()));
			
			if (matchingValues != null){
				if (matchingValues.size() >0){
					for (Iterator it = matchingValues.iterator();it.hasNext();){
						BTOperations.removeValueObject(tree,value,(Comparable)it.next());
						
					}
				}
			if(log.isDebugEnabled()){         
	         	log.debug("Attempting to remove key '" + value +"'");
	         }

	         BTOperations.removeValue(tree, value, value,parser.getKeyDimension(value.getClass()));
	         if(log.isDebugEnabled()){         
	         	log.debug("Removed key '" + value +"'");
	         }
	         NameSpaceKey tempKey = (NameSpaceKey)value;
	         if(log.isDebugEnabled()){         
	         	log.debug("Attempting to remove name space entry'" + value +"'");
	         }
	         BTOperations.removeValue(tree, value,new NameSpaceWrapper(tempKey.getNameSpace()),parser.getKeyDimension(NameSpaceWrapper.class));

			}
			
	    }
	  
	/* (non-Javadoc)
	 * @see com.jofti.tree.TreeOperationAdapter#remove(java.lang.Comparable, java.lang.Object, com.jofti.btree.BTree, com.jofti.introspect.ClassIntrospector)
	 */
	public void remove(Comparable key, Object value, BTree tree,ClassIntrospector parser) throws IllegalArgumentException, JoftiException{
        // first is it the right type
           try{ 
           	
           	if(log.isDebugEnabled()){         
             	log.debug("Attempting to remove key '" + key +"'");
             }

             BTOperations.removeValue(tree, key, key,parser.getKeyDimension(((NameSpaceKey)key).getKey().getClass()));
             if(log.isDebugEnabled()){         
             	log.debug("Removed key '" + key +"'");
             }
             
           	treeRemove(key,value,tree,parser);

		        NameSpaceKey tempKey = (NameSpaceKey)key;
		        // we index the key first
		         if(log.isDebugEnabled()){         
		         	log.debug("Attempting to remove name space entry'" + tempKey +"'");
		         }
		         BTOperations.removeValue(tree, key,new NameSpaceWrapper(tempKey.getNameSpace()),parser.getKeyDimension(NameSpaceWrapper.class));

         } catch (JoftiException e){
         	throw e;
         }
    }    
	
	 /**
	 * @param key
	 * @param added
	 * @param tree
	 * @param parser
	 */
	private void removeIndexedValues(Object key, List added,BTree tree,ClassIntrospector parser ){
	    	removeIndexedValues(key,added,tree);
    	if (key instanceof NameSpaceKey){
	    	NameSpaceKey tempKey = (NameSpaceKey)key;
	        // we index the key first
	         if(log.isDebugEnabled()){         
	         	log.debug("Attempting to remove name space entry'" + tempKey +"'");
	         }
	         try {
	         	BTOperations.removeValue(tree, new NameSpaceWrapper(tempKey.getNameSpace()),(Comparable)key,parser.getKeyDimension(NameSpaceWrapper.class));
	         } catch (JoftiException e){
	         	log.warn(e);
	         }
    		}
    }
	
	 /* (non-Javadoc)
	 * @see com.jofti.tree.TreeOperationAdapter#getAllValuesForKey(java.lang.Comparable, com.jofti.btree.BTree, com.jofti.introspect.ClassIntrospector)
	 */
	public Map getAllValuesForKey(Comparable key, BTree tree, ClassIntrospector parser)throws JoftiException{
	 	
	 	 return BTOperations.match(tree,key, parser.getKeyDimension(key.getClass()));
 	 
   } 
	 
	 /**
	 * @param tree
	 * @param parser
	 * @return A Collection of all the values in that dimension
	 * @throws JoftiException
	 */
	public Collection getAllValuesForDimension(BTree tree, ClassIntrospector parser)throws JoftiException{
	 	final Set tempSet = new LinkedHashSet();
	 	Map keyDimensions = parser.getKeyDimensions();
	 	
	 	
	 	for(Iterator it = keyDimensions.entrySet().iterator();it.hasNext();){
	 		Map.Entry entry = (Map.Entry) it.next();
	 		if (!(entry.getKey() instanceof NameSpaceWrapper)){
	 			OpenHashMap tempMap = (OpenHashMap)BTOperations.getAllResultsForDimension(tree, ((Integer)entry.getValue()).intValue());
	 			tempMap.forEachKey(new ObjectProcedureAdapter(){
	 				public boolean apply(Object key){
	 					tempSet.add(key);
	 					return true;
	 				}
	 			});
	 			//tempSet.addAll(.keySet());
	 		}
	 		
	 	}
	 	return tempSet; 
 	 
   } 
}
