/*
 *
 * Created on 01 June 2003, 08:32
 */

package com.jofti.tree;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.api.IndexQuery;
import com.jofti.api.NameSpaceKey;
import com.jofti.btree.BTOperations;
import com.jofti.btree.BTree;
import com.jofti.btree.ValueObject;
import com.jofti.cache.adapter.NameSpaceWrapper;
import com.jofti.core.IParsedQuery;
import com.jofti.core.InternalIndex;
import com.jofti.core.QueryId;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.parser.ConvenienceQueryWrapper;
import com.jofti.parser.ParserManager;
import com.jofti.query.MatchInQuery;
import com.jofti.query.MatchNotQuery;
import com.jofti.query.MatchQuery;
import com.jofti.query.MatchRangeQuery;
import com.jofti.query.namespace.MatchNSInQuery;
import com.jofti.query.namespace.MatchNSLargerQuery;
import com.jofti.query.namespace.MatchNSNotQuery;
import com.jofti.query.namespace.MatchNSQuery;
import com.jofti.query.namespace.MatchNSRangeQuery;
import com.jofti.query.namespace.MatchNSSmallerQuery;
/**
 *
 * @author  xenephon (xenephon@jofti.com)
 */
public class NameSpacedTreeIndex extends TreeIndex
{
	
	
	private static Log log =  LogFactory.getLog(NameSpacedTreeIndex.class);
	
	
    
    
    public NameSpacedTreeIndex(){
    		super();
    }
    
    
    public NameSpacedTreeIndex(BTree tree, ClassIntrospector parser) 
    {
    	
        super(tree,parser);
        
       
        
    }
    
    public NameSpacedTreeIndex(BTree tree, ClassIntrospector parser, Map indexedDimensions) 
    {
    	
        super(tree,parser, indexedDimensions);
        
       
        
    }
    
    /* (non-Javadoc)
     * @see com.jofti.tree.TreeIndex#init(java.util.Properties)
     */
    public void init(Properties props) throws JoftiException{
    	tree.init(props);
    	engine = new NameSpacedTreeMatcherEngine();
    	// start expiry clean up thread
    	parserManager = new ParserManager(introspector);
     	this.treeAdapter = new NameSpaceTreeOperationAdapter();
    	
    }
    

    public Map query(IndexQuery query) throws JoftiException {
        
    	// query lock is delegated to matching engine for this method
        NameSpacedTreeMatcherEngine tempEngine = (NameSpacedTreeMatcherEngine)engine;
        
       
        if (query == null){
            throw new JoftiException("Query object cannot be null");
        }
        
        QueryId queryId = (QueryId)query;
        
        switch(queryId.getQueryType().type){
            case 200 :
            	 MatchNSQuery tempQuery = (MatchNSQuery)((ConvenienceQueryWrapper)query).getQuery();
                 if (tempQuery.getPropertyName() ==null && tempQuery.getValue() == null){
                     return tempEngine.matchNameSpace(tempQuery, this);
                 } else{
                     return tempEngine.matchProperty(tempQuery, this);
                 }
            case 201:
                return tempEngine.matchPropertyRange((MatchNSRangeQuery) ((ConvenienceQueryWrapper)query).getQuery(), this);
            case 202:
                return tempEngine.matchNotProperty((MatchNSNotQuery) ((ConvenienceQueryWrapper)query).getQuery(), this);
                //common query type
            case 0:
                return tempEngine.processQuery((IParsedQuery)query, this);
            case 203:
                return tempEngine.matchProperty((MatchNSInQuery)((ConvenienceQueryWrapper)query).getQuery(), this);
            default:
                throw new JoftiException("Query type "+ query.getClass() + " cannot be used for Name Spaced IndexCache");

        }


    }
    
    /**
     * Gets a Collection of all the key entries.<p>
     * @return a Collection
     * @throws JoftiException
     */
    public Collection getAllKeyEntriesFromTree() throws JoftiException {

		return ((NameSpaceTreeOperationAdapter)treeAdapter).getAllValuesForDimension(tree,introspector);
	}
    
	

	

}
