package com.jofti.tree;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.btree.BTOperations;
import com.jofti.cache.adapter.NameSpaceWrapper;
import com.jofti.exception.JoftiException;
import com.jofti.exception.PropertyNotIndexedException;
import com.jofti.manager.IndexManagerImpl;
import com.jofti.parser.CommonLexerTokenTypes;
import com.jofti.parser.sql.SQLQueryParserTokenTypes;
import com.jofti.query.namespace.MatchNSInQuery;
import com.jofti.query.namespace.MatchNSLargerQuery;
import com.jofti.query.namespace.MatchNSNotQuery;
import com.jofti.query.namespace.MatchNSQuery;
import com.jofti.query.namespace.MatchNSRangeQuery;
import com.jofti.query.namespace.MatchNSSmallerQuery;
import com.jofti.util.OpenHashMap;

/**
 * @author Steve Woodcock (steve@jofti.com)
 *

 */
public class NameSpacedTreeMatcherEngine extends AbstractMatchingEngine{

	private static Log log =  LogFactory.getLog(IndexManagerImpl.class);
	/* (non-Javadoc)
	 * @see com.jofti.engine.IQueryEngine#query(com.jofti.api.IndexQuery)
	 */
	

	protected Map constructReturnMap(Collection col){
		LinkedHashMap map = new LinkedHashMap(col.size());
		int size =col.size();
		Iterator it = col.iterator();
		for(int i=0;i<size;i++){

			map.put(it.next(),null);
		}
		return map;
	}
	
	protected Map matchNameSpace(MatchNSQuery query, TreeIndex index) throws JoftiException{
		
	    // we need to find the dimension from the name here	
		int dimension = index.introspector.getKeyDimension(NameSpaceWrapper.class);
       return BTOperations.match(index.tree, (Comparable)query.getNameSpaceWrapper(), dimension, query.alias);
			    
	 
		}
	
	protected Map matchProperty(MatchNSQuery query, TreeIndex index) throws JoftiException{
		
			        // we need to find the dimension from the name here
					
			    	int dimension =0;
			    		try {
			    			if (query.getPropertyName() == null) {
			    				dimension = index.introspector.getDimension(query.getValue().getClass().getName(), null);
			    			} else {
			    				dimension = index.introspector.getDimension(query.getClassName(),query.getPropertyName());
			    			}
			    		} catch (PropertyNotIndexedException e){
			    			//no property match found
			    			return new OpenHashMap(1);
			    		}catch (JoftiException e){
			    			throw e;
			    		}

			        //log.info("Looking for property " + propertyName + " with index " + dimension);
			    		return BTOperations.match(index.tree, wrapNull(query.getValue()), dimension,query.alias);
			      
		}
	
	protected Map matchIsProperty(MatchNSQuery query, TreeIndex index) throws JoftiException{
	
		        // we need to find the dimension from the name here
				
		    	int dimension =0;
		    		try {
		    			if (query.getPropertyName() == null) {
		    				
		    					dimension = index.introspector.getDimension(query.getClassName(), null);
		    			} else {
		    				dimension = index.introspector.getDimension(query.getClassName(),query.getPropertyName());
		    			}
		    		} catch (PropertyNotIndexedException e){
		    			//no property match found
		    			return new OpenHashMap(1);
		    		}catch (JoftiException e){
		    			throw e;
		    		}

		        //log.info("Looking for property " + propertyName + " with index " + dimension);
		    		return BTOperations.match(index.tree, wrapNull(null), dimension,query.alias);
		       

		    
 
	}
	
	
	protected Map matchProperty(MatchNSInQuery query, TreeIndex index) throws JoftiException{
		
			        // we need to find the dimension from the name here
					
		 int dimension = 0;
	        try {
	        	if (query.getValues() == null || query.getValues()[0] == null){
	        		return new OpenHashMap(1);
	        	}
	            if (query.getPropertyName() == null) {
	            	
	                dimension = index.introspector.getDimension(query.getValues()[0]
	                        .getClass(), null);
	            } else {
	                dimension = index.introspector.getDimension(query.getClassName(),
	                        query.getPropertyName());
	            }
	        } catch (PropertyNotIndexedException e) {
	            //no property match found
	            return new OpenHashMap(1);
	        } catch (JoftiException e) {
	            throw e;
	        }
	        
	        return BTOperations.match(index.tree, query.getValues(),
	                dimension, query.alias);
			        //log.info("Looking for property " + propertyName + " with index " + dimension);
			       

			    
	 
		}
		
		
	
	/**
	 * @param cache
	 * @param col
	 * @return
	 * @throws JoftiException
	 */

	
	
	
	
	 
	 protected Map matchPropertyRange(MatchNSRangeQuery query, TreeIndex index) throws JoftiException{
		
			        // we need to find the dimension from the name here
	      // we need to find the dimension from the name here
	 	if (query.getStartValue() != null && query.getEndValue() != null){
		 	if (!((query.getStartValue().getClass().equals(query.getEndValue().getClass())))	){
		 		throw new JoftiException("Classes for property range query must be the same. start:"+query.getStartValue().getClass() + " end:"+query.getEndValue().getClass());
		 	}
		 	if (query.getStartValue().compareTo(query.getEndValue()) >0){
		 		if(log.isDebugEnabled()){
		 			log.info("Range search: start range " +query.getStartValue() + " is greater then end range "+ query.getEndValue() + " returning empty results" );
		 		}
		 		return new OpenHashMap(1);
		 	}
	 	}
			    	int dimension =0;
			    	Class className = null;
					try {

						if (query.getClassName() == null) {
							if (query.getStartValue() != null) {
								className = query.getStartValue().getClass();
							} else if (query.getEndValue() != null) {
								className = query.getEndValue().getClass();
							}
						} else {
							className = query.getClassName();
						}
			    			dimension = index.introspector.getDimension(className, query.getPropertyName());
			    		} catch (PropertyNotIndexedException e){
			    			//no property match found
			    			return new OpenHashMap(1);
			    		}catch (JoftiException e){
			    			throw e;
			    		}
			        
			    		//we need to change this to do the checks on nameSpace
			    		return BTOperations.range(index.tree, query.getStartValue(),query.getEndValue(), dimension,query.isInclusive() , query.alias);
			     
			    
	 
		}

	/* (non-Javadoc)
	 * @see com.jofti.tree.AbstractMatchingEngine#performQuery(int, java.lang.String, java.lang.String, java.lang.Comparable, com.jofti.tree.TreeIndex)
	 */
		protected Map performQuery(int operator, Class className, Object nameSpace,String attribute, Object value, TreeIndex index, Map namedParameters,Object alias) throws JoftiException{
			Map temp = null;
			switch(operator){
			
			
				case SQLQueryParserTokenTypes.ASSIGNEQUAL:
                     Comparable comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute, namedParameters);
					temp = matchProperty(new MatchNSQuery(className, nameSpace,attribute, comp,alias), index);
					break;
                 case SQLQueryParserTokenTypes.IS:
                 	comp = attributeValueParser.constructForIsNot((String)value,namedParameters);
    				temp = matchIsProperty(new MatchNSQuery(className, nameSpace,attribute, comp,alias), index);
					break;
				case SQLQueryParserTokenTypes.GREATERTHAN:;
                     comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
					temp = matchPropertyRange(new MatchNSLargerQuery(className,nameSpace, attribute, comp, false,alias), index);
					break;
				case SQLQueryParserTokenTypes.GREATERTHANOREQUALTO1:;
				case SQLQueryParserTokenTypes.GREATERTHANOREQUALTO2:
                    comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
					temp = matchPropertyRange(new MatchNSLargerQuery(className, nameSpace,attribute, comp,alias), index);
					break;
				case SQLQueryParserTokenTypes.LESSTHANOREQUALTO1:;
				case SQLQueryParserTokenTypes.LESSTHANOREQUALTO2:;
                comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
					temp = matchPropertyRange(new MatchNSSmallerQuery(className,nameSpace, attribute, comp,alias), index);
					break;
				case SQLQueryParserTokenTypes.LESSTHAN:
                    comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
					temp = matchPropertyRange(new MatchNSSmallerQuery(className, nameSpace,attribute, comp,false,alias), index);
					break;
				case SQLQueryParserTokenTypes.NOTEQUAL1:;
				case SQLQueryParserTokenTypes.NOTEQUAL2:
                    comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
					temp = matchNotProperty(new MatchNSNotQuery(className, nameSpace,attribute, comp,alias), index);
					break;
                case SQLQueryParserTokenTypes.NOT:
                	comp = attributeValueParser.constructForIsNot((String)value,namedParameters);
  					temp = matchNotProperty(new MatchNSNotQuery(className, nameSpace,attribute, comp,alias), index);
					break;
                case SQLQueryParserTokenTypes.LIKE:
                    Comparable[] tempVals = attributeValueParser.processVals((String) value,namedParameters); 
                    temp = matchPropertyRange(new MatchNSRangeQuery(className, nameSpace, attribute, tempVals[0],tempVals[1],alias), index);
                    break;
                case CommonLexerTokenTypes.IN:
                    tempVals = attributeValueParser.constructArrayValue(value,index.introspector, className, attribute,namedParameters ); 
                    temp = matchProperty(new MatchNSInQuery(className, nameSpace,attribute, tempVals,alias), index);
                    break;
				default: 
						break;
			}
			return temp;
		}

		protected Map matchNotProperty(MatchNSNotQuery query, TreeIndex index) throws JoftiException {

			// we need to find the dimension from the name here

			int dimension = 0;
			try {
				if (query.getPropertyName() == null) {
					dimension = index.introspector.getDimension(query.getClassName(), null);
				} else {
					dimension = index.introspector.getDimension(query.getClassName(),
							query.getPropertyName());
				}
			} catch (PropertyNotIndexedException e) {
				//no property match found
				return new OpenHashMap(1);
			} catch (JoftiException e) {
				throw e;
			}

			return BTOperations.notEqual(index.tree, wrapNull(query.getValue()),
					dimension, query.alias);
			
			

		} 

}
