/*
 *
 * Created on 01 June 2003, 08:32
 */

package com.jofti.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.api.IndexQuery;
import com.jofti.btree.BTOperations;
import com.jofti.btree.BTree;
import com.jofti.btree.ValueObject;
import com.jofti.core.IParsedQuery;
import com.jofti.core.InternalIndex;
import com.jofti.core.QueryId;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;
import com.jofti.manager.IndexManagerImpl;
import com.jofti.parser.ConvenienceQueryWrapper;
import com.jofti.parser.ParserManager;
import com.jofti.query.MatchInQuery;
import com.jofti.query.MatchNotQuery;
import com.jofti.query.MatchQuery;
import com.jofti.query.MatchRangeQuery;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
/**
 *
 *
 * The wrapper for the IndexCache that integrates the BTree implementation, the introspector 
 * and the query engine.
 *
 *  @author  xenephon (xenephon@jofti.com)
 */
public class TreeIndex implements InternalIndex
{
	public final String KEY_DIMENSION = "com.activescript.KEY_DIMENSION";
	
	protected static int DEFAULT_OFFERTIME =1000;
	
	protected long REMOVAL_WATCHER_SLEEP_TIME =3000;
	
	private static Log log =  LogFactory.getLog(IndexManagerImpl.class);
	
    
	protected TreeOperationAdapter treeAdapter = null;
    /** Creates a new instance
     of BTreeWrapper */
    
    BTree tree = null;
    ClassIntrospector introspector = null;
    
    Map indexedDimensions = new ConcurrentHashMap();
    
    protected AtomicLong keyNumber =new AtomicLong(0);
    
    LinkedBlockingQueue removalCandidateQueue = new LinkedBlockingQueue(20000);
    
    
    MatchingEngine engine=null;
    
	ParserManager parserManager = null;
    
    public TreeIndex(){
    	
    }
    
    
    public TreeIndex(BTree tree, ClassIntrospector parser) 
    {
    	
        this.tree = tree;
        this.introspector = parser;
        
       
        
    }
    
    public TreeIndex(BTree tree, ClassIntrospector parser, Map indexedDimensions) 
    {
    	
        this.tree = tree;
        this.introspector = parser;
        this.indexedDimensions = indexedDimensions;

       
        
    }
    
    /**
     * @param props
     * @throws JoftiException
     */
    public void init(Properties props) throws JoftiException{
    	tree.init(props);
    	engine = new TreeMatcherEngine();
    	parserManager = new ParserManager(introspector);
    	
    	this.treeAdapter = new TreeOperationAdapter();
    	
    }
    
    public Map query(IndexQuery query) throws JoftiException{
    	//return engine.query(query, this);
    	TreeMatcherEngine tempEngine = (TreeMatcherEngine)engine;
    	if (query == null) {
			throw new JoftiException("Query object cannot be null");
		}

        QueryId queryId = (QueryId)query;
        
        switch(queryId.getQueryType().type){
            case 100 :
                return tempEngine.matchProperty((MatchQuery) ((ConvenienceQueryWrapper)query).getQuery(), this);
            case 101:
                return tempEngine.matchPropertyRange((MatchRangeQuery) ((ConvenienceQueryWrapper)query).getQuery(), this);
            case 102:
                return tempEngine.matchNotProperty((MatchNotQuery) ((ConvenienceQueryWrapper)query).getQuery(), this);
            case 0:
                return tempEngine.processQuery((IParsedQuery)query, this);
            case 103:
                return tempEngine.matchProperty((MatchInQuery)((ConvenienceQueryWrapper)query).getQuery(), this);
            default:
                throw new JoftiException("Query type " + ((ConvenienceQueryWrapper)query).getQuery().getClass()
                        + " cannot be used for Non nameSpaced IndexCache");
        }

    }
    
     /* (non-Javadoc)
     * @see com.jofti.core.InternalIndex#contains(java.lang.Object)
     */
    public boolean contains(Object key)throws JoftiException{
         try {
             return treeAdapter.contains( (Comparable)key, tree,introspector);
         } catch (Throwable e) {
             if (!(e instanceof JoftiException)) {
             	while(e.getCause() != null){
             		System.err.println(e);
             		e = e.getCause();
             	}
                 throw new JoftiException(e);  
             }else{
             	while(e.getCause() != null){
             		System.err.println(e);
             		e = e.getCause();
             	}
                 throw (JoftiException)e;
             }
        }
     }
    
     
     /* (non-Javadoc)
     * @see com.jofti.core.InternalIndex#insert(java.lang.Object, java.lang.Object)
     */
    public void insert (Object key, Object value) throws IllegalArgumentException, JoftiException{
     	try{
         
             treeAdapter.insert((Comparable)key, value,tree, introspector);
         	keyNumber.incrementAndGet();
         } catch (Throwable e) {
             if (!(e instanceof JoftiException)) {
             	System.err.println("error at " + keyNumber);
             	while(e.getCause() != null){
             		System.err.println(e);
             		e = e.getCause();
             	}
                 throw new JoftiException(e);  
             }else{
             	while(e.getCause() != null){
             		System.err.println(e);
             		e = e.getCause();
             	}
                 throw (JoftiException)e;
             }
         }
     }
     
   
    public void insertEntry (Object key, Object value) throws IllegalArgumentException, JoftiException{
     	try{
         
             treeAdapter.insertEntry((Comparable)key, value,tree, introspector);
         	keyNumber.incrementAndGet();
         } catch (Throwable e) {
             if (!(e instanceof JoftiException)) {
                 throw new JoftiException(e);  
             }else{
                 throw (JoftiException)e;
             }
         }
     }
    
    
    /* (non-Javadoc)
     * @see com.jofti.core.InternalIndex#remove(java.lang.Object, java.lang.Object)
     */
    public void remove(Object key, Object value) throws IllegalArgumentException, JoftiException{
        try {
        	    treeAdapter.remove((Comparable)key, value,tree, introspector);
         	keyNumber.decrementAndGet();
        } catch (Throwable e) {
            if (!(e instanceof JoftiException)) {
                throw new JoftiException(e);  
            }else{
                throw (JoftiException)e;
            }
            
        }   	
    }    
    
 /* (non-Javadoc)
 * @see com.jofti.core.InternalIndex#removeByKey(java.lang.Object)
 */
public void removeByKey(Object key) throws IllegalArgumentException, JoftiException{
        try {
        	    treeAdapter.removeByKey((Comparable)key, tree, introspector);
        	    keyNumber.decrementAndGet();
         } catch (Throwable e) {
             if (!(e instanceof JoftiException)) {
                 throw new JoftiException(e);  
             }else{
                 throw (JoftiException)e;
             }
             
         }     	
    }  
    
  

    
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" tree:" + tree);
        return buf.toString();
    }
    
      
    /* (non-Javadoc)
	 * @see com.jofti.core.InternalIndex#getEntries(java.lang.Comparable)
	 */
	public Map getEntries(Object key) throws JoftiException {
        try{
            return treeAdapter.getAllValuesForKey((Comparable)key,tree,introspector);
         } catch (Throwable e) {
             if (!(e instanceof JoftiException)) {
                 throw new JoftiException(e);  
             }else{
                 throw (JoftiException)e;
             }
             
         } 
	}
    
	
	public Map getAllEntries() throws JoftiException {
        try{
        	return treeAdapter.getAllValuesForTree(tree, introspector);
        	
         } catch (Throwable e) {
             if (!(e instanceof JoftiException)) {
                 throw new JoftiException(e);  
             }else{
                 throw (JoftiException)e;
             }
             
         } 
	}
	
	/* (non-Javadoc)
	 * @see com.jofti.core.InternalIndex#getAttributesByKey(java.lang.Object)
	 */
	public Map getAttributesByKey(Object key) throws JoftiException {
		try{
		Collection col = treeAdapter.getAttribsByKey((Comparable)key,tree,introspector);
		if(col ==null || col.size()==0){
			return new HashMap(2);
		}
		Map temp = new HashMap(col.size());
		int size =col.size();
		Iterator it = col.iterator();
		for (int i=0;i<size;i++){
			ValueObject obj = (ValueObject)it.next();
			temp.put(new Integer(obj.getDimension()),obj.getRealValue());
		}
		return temp;
    } catch (Throwable e) {
        if (!(e instanceof JoftiException)) {
            throw new JoftiException(e);  
        }else{
            throw (JoftiException)e;
        }
        
    } 
	}
    

	
	
    /* (non-Javadoc)
     * @see com.jofti.core.InternalIndex#removeAll()
     */
    public void removeAll()
    {
        tree.removeAll();
        keyNumber =new AtomicLong(0);
    }    
 
	/**
	 * @return Returns the tree.
	 */
	BTree getTree() {
		return tree;
	}
	/**
	 * @param tree The tree to set.
	 */
	public void setTree(BTree tree) {
		this.tree = tree;
	}
	
	/**
	 * @return Returns the parser.
	 */
	public ClassIntrospector getIntrospector() {
		return introspector;
	}
	/**
	 * @param parser The parser to set.
	 */
	public void setParser(ClassIntrospector parser) {
		this.introspector = parser;
	}


	
	
	

	/**
	 * @return Returns the keyNumber.
	 */
	public long getKeyNumber() {
		return keyNumber.get();
	}


	public synchronized ParserManager getParserManager() {
		return parserManager;
	}


	
}
