package com.jofti.tree;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.btree.BTOperations;
import com.jofti.exception.JoftiException;
import com.jofti.exception.PropertyNotIndexedException;
import com.jofti.manager.IndexManagerImpl;
import com.jofti.parser.CommonLexerTokenTypes;
import com.jofti.query.MatchInQuery;
import com.jofti.query.MatchNotQuery;
import com.jofti.query.MatchQuery;
import com.jofti.query.MatchRangeQuery;
import com.jofti.util.OpenHashMap;


/**
 * @author Steve Woodcock (steve@jofti.com)
 *
 */
public class TreeMatcherEngine extends AbstractMatchingEngine {


	
	private static Log log = LogFactory.getLog(IndexManagerImpl.class);
	
	

	
	protected Map performQuery(int operator, Class className, Object nameSpace,String attribute, Object value, TreeIndex index, Map namedParameters, Object alias) throws JoftiException{
		Map temp = null;
		
		switch(operator){
		
			
			case CommonLexerTokenTypes.ASSIGNEQUAL:
                 Comparable comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);	
				temp = matchProperty(className, attribute, comp, alias, index);

				break;
             case CommonLexerTokenTypes.IS:
             	comp = attributeValueParser.constructForIsNot((String)value,namedParameters);
  				temp = matchIsProperty(new MatchQuery(className, attribute, comp, alias), index);
				
				break;
			case CommonLexerTokenTypes.GREATERTHAN:;
                comp = attributeValueParser.constructValue((String)value,index.introspector,className,attribute,namedParameters);
				temp = matchPropertyRange(className, attribute, comp, null,false,alias, index);
				break;
			case CommonLexerTokenTypes.GREATERTHANOREQUALTO1:;
			case CommonLexerTokenTypes.GREATERTHANOREQUALTO2:
                comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
				temp = matchPropertyRange(className, attribute, comp,null,true,alias, index);
				break;
			case CommonLexerTokenTypes.LESSTHANOREQUALTO1:;
			case CommonLexerTokenTypes.LESSTHANOREQUALTO2:;
                comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
				temp = matchPropertyRange(className, attribute, null,comp,true,alias, index);
				break;
			case CommonLexerTokenTypes.LESSTHAN:
                 comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
				temp = matchPropertyRange(className, attribute, null,comp,false,alias, index);
				break;
			case CommonLexerTokenTypes.NOTEQUAL1:;
			case CommonLexerTokenTypes.NOTEQUAL2:
                comp = attributeValueParser.constructValue((String)value, index.introspector,className,attribute,namedParameters);
				temp = matchNotProperty(new MatchNotQuery(className, attribute, comp,alias), index);
				break;
            case CommonLexerTokenTypes.NOT:
            	comp = attributeValueParser.constructForIsNot((String)value,namedParameters);
 				temp = matchNotProperty(new MatchNotQuery(className, attribute, comp,alias), index);
				break;
            case CommonLexerTokenTypes.LIKE:
            	    Comparable[] tempVals = attributeValueParser.processVals((String) value,namedParameters); 
				temp = matchPropertyRange(className, attribute, tempVals[0],tempVals[1],true,alias, index);
				break;
            case CommonLexerTokenTypes.IN:
                tempVals = attributeValueParser.constructArrayValue(value,index.introspector, className, attribute,namedParameters ); 
                temp = matchProperty(new MatchInQuery(className, attribute, tempVals,alias), index);
                break;
           
			default: 
					break;
		}
		return temp;
	}

	
	
		
	
	public Map matchProperty(MatchQuery query, TreeIndex index) throws JoftiException {
		return matchProperty(query.className,query.propertyName, query.value,query.alias, index);
	}

		public Map matchProperty(final Class className, final String attribute, final Comparable comp, final Object alias,TreeIndex index) throws JoftiException {
			
		// we need to find the dimension from the name here

		int dimension = 0;
		try {
			if (comp ==null){
				throw new JoftiException("null is not allowed in equals query use IS query");
			}
			if (attribute == null) {
				
				dimension = index.introspector.getDimension(comp.getClass(), null);
			} else {
				dimension = index.introspector.getDimension(className,
						attribute);
			}
		} catch (PropertyNotIndexedException e) {
			//no property match found
			return new OpenHashMap(1);
		} catch (JoftiException e) {
			throw e;
		}

		//log.info("Looking for property " + propertyName + " with index " + dimension);

		return BTOperations.match(index.tree,comp,
				dimension, alias);
		
		

	}
    
	
	public Map matchIsProperty(MatchQuery query, TreeIndex index) throws JoftiException {

		// we need to find the dimension from the name here

		int dimension = 0;
		try {
			if (query.getPropertyName() == null) {	
				dimension = index.introspector.getDimension(query.getClassName(), null);
			} else {
				dimension = index.introspector.getDimension(query.getClassName(),
						query.getPropertyName());
			}
		} catch (PropertyNotIndexedException e) {
			//no property match found
			return new OpenHashMap(1);
		} catch (JoftiException e) {
			throw e;
		}

		//log.info("Looking for property " + propertyName + " with index " + dimension);

		return BTOperations.match(index.tree, wrapNull(null),
				dimension, query.alias);
		
		

	}
    
    public Map matchProperty(MatchInQuery query, TreeIndex index) throws JoftiException {

        // we need to find the dimension from the name here

        int dimension = 0;
        Comparable[] values =query.getValues();
        try {
        	if (values == null || values[0] == null){
        		return new OpenHashMap(1);
        	}
            if (query.getPropertyName() == null) {
            	
                dimension = index.introspector.getDimension(values[0]
                        .getClass(), null);
            } else {
                dimension = index.introspector.getDimension(query.getClassName(),
                        query.getPropertyName());
            }
        } catch (PropertyNotIndexedException e) {
            //no property match found
            return new OpenHashMap(1);
        } catch (JoftiException e) {
            throw e;
        }

        //log.info("Looking for property " + propertyName + " with index " + dimension);

        return BTOperations.match(index.tree, values,
                dimension, query.alias);
        
        

    }
	
	public Map matchNotProperty(MatchNotQuery query, TreeIndex index) throws JoftiException {

		// we need to find the dimension from the name here

		int dimension = 0;
		try {
			if (query.getPropertyName() == null) {
				dimension = index.introspector.getDimension(query.getValue()
						.getClass(), null);
			} else {
				dimension = index.introspector.getDimension(query.getClassName(),
						query.getPropertyName());
			}
		} catch (PropertyNotIndexedException e) {
			//no property match found
            return new OpenHashMap(1);
		} catch (JoftiException e) {
			throw e;
		}

		//log.info("Looking for property " + propertyName + " with index " + dimension);

		return BTOperations.notEqual(index.tree, wrapNull(query.getValue()),
				dimension, query.alias);
		
		

	}
	
	/**
	 * @param cache
	 * @param col
	 * @return
	 * @throws JoftiException
	 */
	

	public Map matchPropertyRange(MatchRangeQuery query,
			TreeIndex index) throws JoftiException {
		return matchPropertyRange(query.getClassName(),query.getPropertyName(),query.getStartValue(), query.getEndValue(),
		query.isInclusive(),query.alias,index);
		
	}
	public Map matchPropertyRange(Class className, String attribute, Comparable startValue, 
			Comparable endValue,boolean inclusive, Object alias, 
				TreeIndex index) throws JoftiException {
		// we need to find the dimension from the name here
		// we need to find the dimension from the name here
		if (startValue != null && endValue != null) {
			if (!((startValue.getClass().equals(endValue
					.getClass())))) {
				throw new JoftiException(
						"Classes for property range query must be the same. start:"
								+ startValue.getClass() + " end:"
								+ endValue.getClass());
			}
			if (startValue.compareTo(endValue) > 0) {
				if (log.isDebugEnabled()) {
					log.info("Range search: start range "
							+ startValue
							+ " is greater then end range "
							+ endValue + " returning empty results");
				}
				return new OpenHashMap(1);
			}
		}
		int dimension = 0;
		try {

			if (className == null) {
				if (startValue != null) {
					className = startValue.getClass();
				} else if (endValue != null) {
					className = endValue.getClass();
				}
			}

			dimension = index.introspector.getDimension(className,attribute);
		} catch (PropertyNotIndexedException e) {
			//no property match found
			return new OpenHashMap(1);
		} catch (JoftiException e) {
			throw e;
		}

		//log.info("Looking for property " + propertyName + " with index " + dimension);

		return BTOperations.range(index.tree, startValue,
				endValue, dimension, inclusive, alias);
		

	}

	
}
