
/*
 * Created on 13-May-2005
 *
 */
package com.jofti.tree;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.btree.BTOperations;
import com.jofti.btree.BTree;
import com.jofti.btree.KeyValueObject;
import com.jofti.btree.ValueObject;
import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;

/**
 * @author Steve Woodcock (steve@jofti.com)
 *
 */
public class TreeOperationAdapter {

	
	
	private static Log log =  LogFactory.getLog(TreeOperationAdapter.class);
	
	
	public void insertEntry(Comparable key, Object value, BTree tree,ClassIntrospector parser) throws IllegalArgumentException, JoftiException{
		List addedObjects = new ArrayList();
		
		ValueObject val = (ValueObject)value;
		
		 try {
			 
			
		 	  if(log.isDebugEnabled()){         
	         	log.debug("Attempting to insert key '" + key +"'");
		 	  }
	        
		 	  if (val.getDimension() <0){
		 		  // must be a key value
		       BTOperations.insertKeyValue(tree, key, ((KeyValueObject)val).getAttributes(),val.getDimension());
		         addedObjects.add(key);
		 	  }else{
                  BTOperations.insertValue(tree, key, (Comparable)val.getRealValue(),val.getDimension());
		 	  }
		 } catch (JoftiException e){
	         	log.error("Error encountered - removing indexed objects " + addedObjects,e);
	    		removeIndexedValuesByKey(addedObjects,tree ,parser);
	    	}
		
	}
	
	
	public void insert(Comparable key, Object value, BTree tree,ClassIntrospector parser) throws IllegalArgumentException, JoftiException{
        // first is it the right type
		List addedObjects = new ArrayList();
		 Map attributes = parser.getAttributeValues(value);
		 if (attributes == null || attributes.isEmpty()){
			 if(log.isDebugEnabled()){         
		         	log.debug("No attributes found for '" + key +"' ignoring in index");
		      } 
			 return;
		 }
		 try {
			 
			
		 	  if(log.isDebugEnabled()){         
	         	log.debug("Attempting to insert key '" + key +"'");
	         }
		 	 
		 	  // we index the key first
              
	         BTOperations.insertKeyValue(tree, key, attributes,parser.getKeyDimension(key.getClass()));
	         addedObjects.add(key);
	         if(log.isDebugEnabled()){         
	         	log.debug("inserted key '" + key +"'");
	         }
	         
	        
	         
		 	 treeInsert(key,tree,attributes,addedObjects);
		 	
		 } catch (JoftiException e){
         	log.error("Error encountered - removing indexed objects " + addedObjects,e);
    		removeIndexedValues(key,addedObjects,tree );
    	}
    }    
	
	protected void treeInsert(Comparable key,  BTree tree,Map attributes, List addedObjects) throws IllegalArgumentException, JoftiException{
	      
		int size =attributes.entrySet().size();
		Iterator it =  attributes.entrySet().iterator();
		for(int i=0;i<size;i++){
		        	Map.Entry entry = (Map.Entry)it.next();
		        	
			        	if(log.isDebugEnabled()){         
			             	log.debug("Attempting to insert key '" + key +"' value '" + entry.getValue());
			             }
                        
                        if (entry.getValue().getClass().isArray()){
                            Object temp = entry.getValue();
                            // we need to loop through the values here
                            int arraySize = Array.getLength(temp);
                            for (int j=0;j<arraySize;j++){
                                Object val  = Array.get(temp,j);
                                BTOperations.insertValue(tree, key, (Comparable)val,((Integer)entry.getKey()).intValue());
                                
                            }
                        }else{
                            BTOperations.insertValue(tree, key, (Comparable)entry.getValue(),((Integer)entry.getKey()).intValue());
                        }
		        		addedObjects.add(entry.getValue());
		        		if(log.isDebugEnabled()){         
			             	log.debug("Insert key '" + key +"' value '" + entry.getValue());
			             }
		       	        	
		        }
	        
	}
	
	public void remove(Comparable key, Object value, BTree tree,ClassIntrospector parser) throws IllegalArgumentException, JoftiException{
        // first is it the right type
		
		treeRemove(key,value,tree,parser);
                  
		if(log.isDebugEnabled()){         
         	log.debug("Attempting to remove key '" + key +"'");
         }

         BTOperations.removeValue(tree, key, key,parser.getKeyDimension(key.getClass()));
         if(log.isDebugEnabled()){         
         	log.debug("Removed key '" + key +"'");
         }
    }    
	
	protected void treeRemove(Comparable key, Object value, BTree tree,ClassIntrospector parser) throws IllegalArgumentException, JoftiException{
		
         try {
	        Map attributes = parser.getAttributeValues(value);
	        
	        for (Iterator it = attributes.entrySet().iterator();it.hasNext();){
	        	Map.Entry entry = (Map.Entry)it.next();
	        	if(log.isDebugEnabled()){         
	             	log.debug("Attempting to remove key '" + key +"' value '" + entry.getValue());
	             }
	        	BTOperations.removeValue(tree, key, (Comparable)entry.getValue(),((Integer)entry.getKey()).intValue());
	        	if(log.isDebugEnabled()){         
	             	log.debug("Removed key '" + key +"' value '" + entry.getValue());
	             }   	
	        }
         } catch (JoftiException e){
         	throw e;
         }
	}
	
	 public void removeIndexedValuesByKey(List added,BTree tree,ClassIntrospector parser ){
	    	for (Iterator it = added.iterator();it.hasNext();){
	    		Comparable  obj =null;
	    		try {	
	    			obj = (Comparable)it.next();
	    			removeByKey(obj,tree, parser);
	    		} catch (JoftiException e){
	    			log.error("unable to remove value " + obj +" under key " + obj,e);
	    		}
	    	}
	    }
	
	
	 public void removeIndexedValues(Object key, List added,BTree tree ){
    	for (Iterator it = added.iterator();it.hasNext();){
    		Comparable  obj =null;
    		try {	
    			obj = (Comparable)it.next();
    			BTOperations.removeValueObject(tree, key, obj);
    		} catch (JoftiException e){
    			log.error("unable to remove value " + obj +" under key " + key,e);
    		}
    	}
    }
	
	  public void removeEntries(Comparable value, BTree tree, ClassIntrospector parser) throws JoftiException
	    {
			Collection matchingValues = BTOperations.getAllValuesForKey(tree,value,parser.getKeyDimension(value.getClass()));

			for (Iterator it = matchingValues.iterator();it.hasNext();){
				BTOperations.removeValueObject(tree,value,(Comparable)it.next());
				
			}
	    }
	  
	  public void removeByKey(Comparable value, BTree tree, ClassIntrospector parser) throws JoftiException
	    {
		  

			Collection matchingValues = BTOperations.getKeyAttributes(tree,value,parser.getKeyDimension(value.getClass()));
			if (matchingValues != null){
				if (matchingValues.size() >0){
				for (Iterator it = matchingValues.iterator();it.hasNext();){
					BTOperations.removeValueObject(tree,value,(Comparable)it.next());
					
				}
				}
				if(log.isDebugEnabled()){         
		         	log.debug("Attempting to remove key '" + value +"'");
		         }
	
		         BTOperations.removeValue(tree, value, value,parser.getKeyDimension(value.getClass()));
		         if(log.isDebugEnabled()){         
		         	log.debug("Removed key '" + value +"'");
		         }
			
			}
			
	    }
	  
	  public Collection getAttribsByKey(Comparable value, BTree tree, ClassIntrospector parser) throws JoftiException
	    {
		  

			return BTOperations.getKeyAttributes(tree,value,parser.getKeyDimension(value.getClass()));

			
	    }
	  
	  public boolean contains(Comparable key,BTree tree, ClassIntrospector parser)throws JoftiException{
    	 return BTOperations.contains(tree, key, parser.getKeyDimension(key.getClass()));
    }
	  	
	 
	 public Map getAllValuesForKey(Comparable key, BTree tree, ClassIntrospector parser)throws JoftiException{
	 	
	 	 return BTOperations.match(tree,key, parser.getKeyDimension(key.getClass()));
 	 
   } 
	 
	 public Map getAllValuesForTree(BTree tree, ClassIntrospector parser)throws JoftiException{
		 

	 	 return BTOperations.getSubTreeKeyValues(tree,null,null,Integer.MIN_VALUE,Integer.MAX_VALUE-1,true);
 	 
   } 
	  
}
