package com.jofti.util;

import java.io.InputStream;
import java.nio.ByteBuffer;



public class ByteBufferArrayInputStream extends InputStream {

    protected ByteBuffer buf = null;



    public ByteBufferArrayInputStream(ByteBuffer buf) {
        this.buf = buf;

    }

    
    
    public final void resetData(ByteBuffer buf) {
        this.buf = buf;
    }
    
    public final int available() {
        return buf.remaining();
    }

    public final int read() {
        return buf.get();
    }

    public final int read(byte[] b, int off, int len) {
       

        if (len > buf.remaining())
            len = (buf.remaining());

        buf.get(b,off,len);
       
        return len;
    }

    public final long skip(long n) {
        if (n >buf.remaining())
            n = buf.remaining();
        if (n < 0)
            return 0;
        buf.position(buf.position()+(int)n);
        return n;
    }

}

