package com.jofti.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CompositeComparator implements Comparator {

	List  comparators = new ArrayList();
	
	public void addComparator(Comparator comp){
		doAdd(comp,false);
	}
	
	public void addComparator(Comparator comp,boolean reverse){
		doAdd(comp,reverse);
	}
	
	private void doAdd(Comparator comp, boolean reverse){
		comparators.add(new ComparatorWrapper(comp,reverse));
		
	}
	
	public int getSize(){
		return comparators.size();
	}
	
	public boolean isReversed(int index){
		if (index < comparators.size()){
			return ((ComparatorWrapper)comparators.get(index)).isReversed();
		}
		return false;
	}
	
	public Comparator getComparator(int index){
		return (Comparator)comparators.get(index);
	}
	public int compare(Object arg0, Object arg1) {
		
		for (int i=0;i<comparators.size();i++){
			ComparatorWrapper comp = (ComparatorWrapper)comparators.get(i);
			
			
			int val = comp.compare(arg0,arg1);
			
			if (val !=0){
				if (comp.isReversed()){
					if(Integer.MIN_VALUE == val) {
	                    val = Integer.MAX_VALUE;
	                } else {                        
	                    val *= -1;
	                }
				}
				return val;
			}
			
		}
		return 0;
		
	}
	
	class ComparatorWrapper implements Comparator{

		public Comparator comp =null;
		boolean reverse =false;
		
		public ComparatorWrapper(Comparator comp, boolean reverse){
			this.comp=comp;
			this.reverse=reverse;
		}
		public int compare(Object o1, Object o2) {
			// TODO Auto-generated method stub
			return comp.compare(o1,o2);
		}
		
		boolean isReversed(){
			return reverse;
		}
		
	}

}
