package com.jofti.util;



import java.io.OutputStream;

import java.io.IOException;

import java.io.InputStream;

import java.io.ByteArrayInputStream;



/**

 * ByteArrayOutputStream implementation that doesn't synchronize methods

 * and doesn't copy the data on toByteArray().

 */

public class FastByteArrayOutputStream extends OutputStream {

    /**

     * Buffer and size

     */

    protected byte[] buf = null;

    protected int size = 0;

    public int realSize = 0;

    protected int initSize =0; 



    /**

     * Constructs a stream with the given initial size

     */

    public FastByteArrayOutputStream(int initSize) {

        this.size = 0;
        this.initSize =initSize;
        this.buf = new byte[initSize];

    }



    /**

     * Ensures that we have a large enough buffer for the given size.

     */

    private void verifyBufferSize(int sz) {

        if (sz > buf.length) {

            byte[] old = buf;

           
            buf = new byte[Math.max(sz,  buf.length +( buf.length /2))];
           

            System.arraycopy(old, 0, buf, 0, old.length);

            old = null;

        }
       

    }



    public int getSize() {

        return size;

    }



    /**

     * Returns the byte array containing the written data. Note that this

     * array will almost always be larger than the amount of data actually

     * written.

     */

    public byte[] getByteArray() {

        return buf;

    }



    public final void write(byte b[]) {

        verifyBufferSize(size + b.length);

        System.arraycopy(b, 0, buf, size, b.length);

        size += b.length;

        realSize+=b.length;

    }



    public final void write(byte b[], int off, int len) {

        verifyBufferSize(size + len);

        System.arraycopy(b, off, buf, size, len);

        size += len;

        realSize+=len;

    }



    public final void write(int b) {

        verifyBufferSize(size + 1);

        buf[size++] = (byte) b;

        realSize++;

    }



    public void reset() {
        
 //       if (buf.length >initSize){
 //           buf = new byte[initSize];
 //       }
//        
    	//keep the headers here
        size = 4;
        realSize=4;

    }



  



}



