/*
 * Created on 05-May-2005
 *
 */
package com.jofti.util;

import java.io.InputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.exception.JoftiException;

/**
 * @author Steve Woodcock (steve@jofti.com)
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PropertyLoader {

	private static Log log =  LogFactory.getLog(PropertyLoader.class);
	
	public static Properties loadProperties(String fileName) throws JoftiException{
		
		InputStream in =null;
		Properties props =new Properties();
		try {
			if(log.isDebugEnabled())
				log.debug("Getting Config");
			log.info("Getting stream for  " + fileName);
			in = PropertyLoader.class.getResourceAsStream(fileName);
			if (in ==null){
				throw new JoftiException("Unable to find "+ fileName+ " ensure file is on classpath ");
			}
			log.info("Got stream for  " + fileName);
			
			props.load(in);
			
		} catch(Exception e){
			 log.error("Error loading "+ fileName+ " ensure file is on classpath " + e);
			 throw new JoftiException(e);
		} finally{
			try
	        {
				if (in != null){
					in.close();
				}
	        } catch (Exception e){
	        	log.error("Error closing input stream for property load " + e);
	        }
		}
		return props;
	}
}
