package com.jofti.util;


import java.util.Comparator;
import java.util.Map;

import com.jofti.exception.JoftiException;
import com.jofti.introspect.ClassIntrospector;

public class ReflectionComparator implements Comparator {

	private Object[] methods =null;
	ClassIntrospector introspector =null;
	
	public ReflectionComparator(Object[] methods, ClassIntrospector introspector){
		this.methods = methods;
		this.introspector = introspector;
	}
	public int compare(Object o1, Object o2) {
		int res =0;
		try {
			
			
			Object or1 = ((Map.Entry)o1).getValue();
			Object or2 = ((Map.Entry)o2).getValue();
			
			Comparable comp1 = (Comparable)introspector.getResultFromMethods(or1, methods);
			Object comp2 = introspector.getResultFromMethods(or2, methods);
		
			res = comp1.compareTo(comp2);
			
			if (res ==0){
				return ((Map.Entry)o1).getKey().toString().compareTo(((Map.Entry)o1).getKey().toString());
			}
		} catch (JoftiException e){
			throw new RuntimeException(e);
		}
		return res;
		
	}

}
