/*
 * Created on 10-Apr-2005

 */
package com.jofti.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jofti.exception.JoftiException;
import com.jofti.model.ComparableBoolean;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;


/**
 * @author xenephon (xenephon@jofti.com)
 *
 */
public class ReflectionUtil {
	

	private static Log log =  LogFactory.getLog(ReflectionUtil.class);
	private static HashMap primitives = new HashMap();
	private static HashMap primitiveWrapperClasses = new HashMap();
	private static Map classMap = new ConcurrentHashMap();
	
	static {
		primitives.put(int.class.getName(), int.class);
		primitives.put(byte.class.getName(), byte.class);
		primitives.put(short.class.getName(), short.class);
		primitives.put(char.class.getName(), char.class);
		primitives.put(long.class.getName(), long.class);
		primitives.put(boolean.class.getName(), boolean.class);
		primitives.put(float.class.getName(), float.class);
		primitives.put(double.class.getName(), double.class);
	}
	
	static {
		primitiveWrapperClasses.put(int.class, Integer.class);
		primitiveWrapperClasses.put(byte.class, Byte.class);
		primitiveWrapperClasses.put(short.class, Short.class);
		primitiveWrapperClasses.put(char.class, Character.class);
		primitiveWrapperClasses.put(long.class, Long.class);
		primitiveWrapperClasses.put(boolean.class, Boolean.class);
		primitiveWrapperClasses.put(float.class, Float.class);
		primitiveWrapperClasses.put(double.class, Double.class);
	}
	
	 public static Class classForName(String name) throws ClassNotFoundException {
	 	Class clazz = null;
		try {
            
			clazz = (Class)classMap.get(name);
			
			if (clazz != null){
				return clazz;
			}
			
			ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
			
            if(classLoader!=null) {
                int i= name.indexOf("[]");
                if (i>-1){
                    String temp = name.substring(0,i);
                     clazz = (Class)primitives.get(temp);
                    if (clazz == null){
                    clazz	= Class.forName(temp,false,classLoader);	
                    }
                     
                    clazz = Array.newInstance(clazz,0).getClass();
                    classMap.put(name,clazz);
                    return clazz;
                    
                }
				//return classLoader.loadClass(name);
                clazz = Class.forName(name,false,classLoader);
                classMap.put(name,clazz);
                return clazz;
                
			} else {
				clazz = Class.forName(name);
				 classMap.put(name,clazz);
                 return clazz;
			}
		}
		catch (Exception e) {
			clazz = Class.forName(name);
			 classMap.put(name,clazz);
             return clazz;
		}
	}
	 
	 public static Object constructObjectValue(Class clazz, String value) throws JoftiException {
	 	
	 	Object o =null;

	 	try {
	 		Class temp = (Class)primitiveWrapperClasses.get(clazz);
	 		if (temp != null){
	 			clazz =temp;
	 		}
	 		if(clazz.equals(Timestamp.class)){
	 			log.info("constructing timestamp");
	 			o= Timestamp.valueOf(value);
	 		}else if (clazz.isAssignableFrom(Date.class)){
	 			o = constructDate(value);	 			
	 		}else if (clazz.equals(Boolean.class)){
	 			o = new ComparableBoolean(value);	 			
	 		}else{
	 			Constructor c = clazz.getConstructor( new Class [] { String.class } );
	 			o = c.newInstance( new Object [] { value} );
	 		}
	 		 
	 	} catch ( NoSuchMethodException e ) {
	        // we have to do something here
	 		// for special classes
	 		throw new JoftiException("Unable to construct "+ clazz + " from String");
		} catch ( InstantiationException e2 ) {
		    // the class is abstract 
			throw new JoftiException (e2);
		} catch ( IllegalAccessException e3 ) {
		    // we don't have permission to create an instance
			throw new JoftiException (e3);
		} catch ( InvocationTargetException e4 ) {
		    // the construct threw an exception
			throw new JoftiException ("Unable to construct "+ clazz + " from String " +value,e4);
		} catch (Exception e){
			throw new JoftiException ("Unable to construct "+ clazz + " from String " +value,e);
		}
		
		return o;

	 }
    
	 
	 
	 public static Date constructDate(String value) throws JoftiException{
		 
		 Date date = null;

		 
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.LONG,DateFormat.LONG).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.LONG,DateFormat.MEDIUM).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.LONG,DateFormat.SHORT).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
		 
			
			
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.LONG ).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.MEDIUM ).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.MEDIUM,DateFormat.SHORT ).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			
			
		 	try {
				date =DateFormat.getDateTimeInstance(DateFormat.SHORT,DateFormat.LONG).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.SHORT,DateFormat.MEDIUM).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateTimeInstance(DateFormat.SHORT,DateFormat.SHORT).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			
            try {
                date =DateFormat.getDateTimeInstance().parse(value);
                return date;
            } catch (ParseException e) {
                // we do not care
            }
            
            
			try {
				date =DateFormat.getDateInstance(DateFormat.LONG).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateInstance(DateFormat.MEDIUM).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateInstance(DateFormat.SHORT).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			try {
				date =DateFormat.getDateInstance(DateFormat.DEFAULT).parse(value);
				return date;
			} catch (ParseException e) {
				// we do not care
			}
			
			throw new JoftiException("Unable to construct java.util.Date from String " +value);

	 }
     
     public static Object getFieldValue(Object obj, String fieldName) throws JoftiException{
            try {
                Class c = obj.getClass();

                // get the reflected object 
                Field field = c.getDeclaredField(fieldName);
                // set accessible true 
                field.setAccessible(true);
                // modify the member varaible
                Object result = field.get(obj);
                
                return result;
            } catch (Throwable t){
                throw new JoftiException(t);
            }
                
        }
     
}
