import Vue from 'vue';
import VueRouter from 'vue-router';
import jQuery from 'jquery';

// Webpack will add the bootstrap css to the bundle.
import 'bootstrap/dist/css/bootstrap.min.css';

import Login from './pages/Login';
import Assets from './pages/Assets';
import App from './App';
import './filters/filters.js';

global.jQuery = jQuery;
global.$ = jQuery;

Vue.config.productionTip = false;

// VueRouter.
// https://router.vuejs.org/guide/essentials/passing-props.html#boolean-mode
Vue.use(VueRouter);
const routes = [
    {path: '/login', component: Login},
    {path: '/assets', component: Assets},
    {path: '*', redirect: '/assets'}
];
const router = new VueRouter({
    routes
});

new Vue({router, render: h => h(App),}).$mount('#app');
