import axios from 'axios';
import NetworkServices from "./NetworkServices";

export default {

    /**
     * Start the given job
     *
     * @param {string} assetName
     * @return {Promise<void|Error>} Promise that resolves or rejects with error
     */
    startJenkinsJob(assetName) {
        return new Promise((resolve, reject) => {
            const url = NetworkServices.addUrlParameter('/api/startBuild', 'assetName', assetName);
            axios.get(url)
                .then(response => {
                    // On success we receive the Jenkins job URL.
                    resolve(response.data);
                })
                .catch(error => {
                    if (error.response) {
                        if (error.response.status === 401) {
                            return reject({
                                errorCode: 'UNAUTHORIZED',
                                errorMessage: 'User is not authorized to start Jenkins'
                            });
                        }
                    }
                    reject(error);
                });
        });
    },

    /**
     * Get a fresh list of all Nexus assets.
     *
     * @return {Promise<{name:string,created:Date}[]|Error>} Promise that resolves with
     * list of assets or rejects with error
     */
    loadAssets() {
        return new Promise((resolve, reject) => {
            axios.get('/api/assets')
                .then(response => {
                    if (!response.data || !Array.isArray(response.data.assets)) {
                        throw Error(`Expecting to receive an array, but received: "${response.data.assets}"`);
                    }
                    resolve(response.data);
                })
                .catch(error => {
                    if (error.response) {
                        if (error.response.status === 401) {
                            return reject({
                                errorCode: 'UNAUTHORIZED',
                                errorMessage: 'User is not authorized to receive assets'
                            });
                        }
                    }
                    reject(error);
                });
        });
    }
};


