export default {
    /**
     * Deep compare object a and b.
     *
     * @param {Object} a Object to compare
     * @param {Object} b Object to compare
     * @return {boolean} True in case a and b are deeply equal
     */
    deepEquals(a, b) {
        if (!a && !b) {
            return true;
        }
        if (!a || !b) {
            return false;
        }
        return JSON.stringify(a) === JSON.stringify(b);
    },

    /**
     * Vue filter: Hide empty objects.
     *
     * @param value Object to display
     * @return {string} Value as string
     */
    hideEmpty(value) {
        if (!value) {
            return '';
        }
        if (typeof value === 'string') {
            return value;
        }
        if (Array.isArray(value) && value.length) {
            return value;
        }
        if (Object.keys(value).length) {
            return JSON.stringify(value);
        }
        return '';
    }

};


