import UCFirstFilter from '../../../src/components/UCFirstFilter';

describe('should capitalize the first character', () => {

    it('should capitalize given text', () => {
        expect(UCFirstFilter.ucfirst('t')).toBe('T');
        expect(UCFirstFilter.ucfirst('test')).toBe('Test');
        expect(UCFirstFilter.ucfirst(' test ')).toBe('Test');
        expect(UCFirstFilter.ucfirst('    test ')).toBe('Test');
        expect(UCFirstFilter.ucfirst(12)).toBe('12');
    });

    it('should keep already capitalized text unchanged', () => {
        expect(UCFirstFilter.ucfirst('Test')).toBe('Test');
        expect(UCFirstFilter.ucfirst('T')).toBe('T');
        expect(UCFirstFilter.ucfirst(' Test ')).toBe('Test');
        expect(UCFirstFilter.ucfirst('    Test ')).toBe('Test');
    });

    it('should return an empty string', () => {
        expect(UCFirstFilter.ucfirst('  ')).toBe('');
        expect(UCFirstFilter.ucfirst('')).toBe('');
        expect(UCFirstFilter.ucfirst(undefined)).toBe('');
        expect(UCFirstFilter.ucfirst(null)).toBe('');
    });

});
