import NetworkServices from '../../../src/services/NetworkServices';

describe('should test the functions from network services', () => {

    it('should parse the given error response', () => {
        const mockedVueInstance = {
            $t: key => {
                if (key === 'loginform.messages.error.invalidusernameorpassword') {
                    return 'invalid password';
                }
                return 'unknown key';
            }
        };

        expect(NetworkServices.extractErrorMessage(undefined, mockedVueInstance)).toBe('');
        expect(NetworkServices.extractErrorMessage('', mockedVueInstance)).toBe('');
        expect(NetworkServices.extractErrorMessage({response: {status: 401}}, mockedVueInstance)).toBe('invalid password');
        expect(NetworkServices.extractErrorMessage({response: {data: {errorDetails: 'details1'}}}, mockedVueInstance)).toBe('details1');
        expect(NetworkServices.extractErrorMessage({response: {data: {errorMessage: 'details2'}}}, mockedVueInstance)).toBe('details2');
        expect(NetworkServices.extractErrorMessage({
            response: {
                data: {
                    errorDetails: 'details1',
                    errorMessage: 'details2'
                }
            }
        }, mockedVueInstance)).toBe('details1');
        expect(NetworkServices.extractErrorMessage({response: {data: {other: 'details3'}}}, mockedVueInstance)).toBe('{"other":"details3"}');
        expect(NetworkServices.extractErrorMessage({message: 'details4'}, mockedVueInstance)).toBe('details4');
        expect(NetworkServices.extractErrorMessage('details5', mockedVueInstance)).toBe('details5');
    });

    it('should throw an error in case vue parameter is empty', () => {
        try {
            NetworkServices.extractErrorMessage('');
            fail('Should have thrown an error');
        } catch (e) {
            expect(e.message).toBe('Invalid or no Vue instance');
        }
        try {
            NetworkServices.extractErrorMessage('', {});
            fail('Should have thrown an error');
        } catch (e) {
            expect(e.message).toBe('Invalid or no Vue instance');
        }
    });

    it('should parse the URL and return query parameters', () => {
        const result = NetworkServices.parseQueryParameters('?username=test&password=test2');
        expect(result.username).toBe('test');
        expect(result.password).toBe('test2');
    });

    it('should parse the URL and return query parameters 2', () => {
        const result = NetworkServices.parseQueryParameters('');
        expect(result).toEqual({});
    });
});
