import UtilityServices from "../../../src/services/UtilityServices";

describe('should test the functions from utility services', () => {

    it('should deep equals the given objects - equal', () => {
        const tmp1 = {test: true};
        expect(UtilityServices.deepEquals('a', 'a')).toBe(true);
        expect(UtilityServices.deepEquals('longer string', 'longer string')).toBe(true);
        expect(UtilityServices.deepEquals(tmp1, tmp1)).toBe(true);
        expect(UtilityServices.deepEquals({a: 1, b: 2, z: false}, {a: 1, b: 2, z: false})).toBe(true);
        expect(UtilityServices.deepEquals(null, null)).toBe(true);
    });

    it('should deep equals the given objects - not equal', () => {
        const tmp1 = {test1: true};
        const tmp2 = {test2: true};
        expect(UtilityServices.deepEquals('a', 'b')).toBe(false);
        expect(UtilityServices.deepEquals('1 longer string', '2 longer string')).toBe(false);
        expect(UtilityServices.deepEquals(tmp1, tmp2)).toBe(false);
        expect(UtilityServices.deepEquals(tmp1, null)).toBe(false);
        expect(UtilityServices.deepEquals(null, tmp1)).toBe(false);
        expect(UtilityServices.deepEquals({a: 1, b: 255, z: false}, {a: 1, b: 2, z: true})).toBe(false);
    });

    it('should convert the phone number', () => {
        expect(UtilityServices.createTelLink('06 20 866 746')).toBe('+31620866746');
        expect(UtilityServices.createTelLink('0548-610138')).toBe('+31548610138');
        expect(UtilityServices.createTelLink('(0548) 61 01 38')).toBe('+31548610138');
        expect(UtilityServices.createTelLink('  0548 610138')).toBe('+31548610138');
        expect(UtilityServices.createTelLink('+31620866746')).toBe('+31620866746');
        expect(UtilityServices.createTelLink('+31-620 866 746')).toBe('+31620866746');
        expect(UtilityServices.createTelLink('08 123 456 78 90')).toBe('081234567890');
        expect(UtilityServices.createTelLink('+44 123 456 78 90')).toBe('+441234567890');
    });

    it('should NOT convert the phone number', () => {
        expect(UtilityServices.createTelLink(' ')).toBe('');
        expect(UtilityServices.createTelLink('')).toBe('');
        expect(UtilityServices.createTelLink()).toBe('');
        expect(UtilityServices.createTelLink('081234567890')).toBe('081234567890');
    });

    it('should display noting in case of empty object', () => {
        expect(UtilityServices.hideEmpty({})).toBe('');
        expect(UtilityServices.hideEmpty('')).toBe('');
        expect(UtilityServices.hideEmpty(undefined)).toBe('');
        expect(UtilityServices.hideEmpty(null)).toBe('');
        expect(UtilityServices.hideEmpty({test:true})).toBe('{"test":true}');
        expect(UtilityServices.hideEmpty('whatever')).toBe('whatever');
        expect(UtilityServices.hideEmpty(['test'])).toEqual(['test']);
    });

});
