// https://cli.vuejs.org/config/#global-cli-config

// const webpack = require("webpack");

// noinspection JSUnusedGlobalSymbols
module.exports = {
    publicPath: './',
    assetsDir: './',

    // Webpack configuration.
    // https://cli.vuejs.org/guide/webpack.html#simple-configuration
    // configureWebpack: config => {
    // console.log('webpack config: ', config);
    // },

    // "chainWebpack" A chaining API to generate and simplify the modification of Webpack configurations.
    // https://cli.vuejs.org/config/#chainwebpack
    // https://github.com/neutrinojs/webpack-chain
    chainWebpack: config => {

        // https://cli.vuejs.org/guide/html-and-static-assets.html#relative-path-imports
        // Run: "$ vue inspect" to see the resulting webpack config.
        const svgRule = config.module
            .rule('svg');
        // Clear all existing loaders. If you don't do this, the loader below will be appended to existing loaders of the rule.
        // https://stackoverflow.com/questions/49459262/vue-cli-3-is-not-allowing-me-to-process-svgs-in-webpack
        svgRule.uses.clear();
        svgRule.use('url-loader')
            .loader('url-loader');

        // Add .ico files.
        const icoRule = config.module.rule('ico');
        icoRule.test(/\.ico$/);
        icoRule.use('url-loader')
            .loader('url-loader');
    },

    // Serve our API stubs through the stub-server running at port 3000.
    devServer: {
        proxy: {
            "/api/*": {
                target: "http://localhost:3000",
                secure: false
            }
        }
    }
};
