// Services to test.
const services = require('./nexus-services');

describe('The nexus-services module', function () {

    beforeEach(() => {
    });

    const expect = require('chai').expect;

    it('should add sort the items based on lastUpdated date', function () {
        const items = [
            {
                name: 'package-name1-1.0.0.tgz',
                date: '2020-04-02T08:31:49.211Z'
            },
            {
                name: 'package-name1-1.1.0.tgz',
                date: '2020-04-01T08:31:49.211Z'
            },
            {
                name: 'package-name1-1.2.0.tgz',
                date: '2020-04-04T08:31:49.211Z'
            },
            {
                name: 'package-name1-1.3.0.tgz',
                date: '2020-04-02T09:30:49.211Z'
            }
        ];

        const result = services._sortByFullNameAndVersion(items);
        expect(result.length).to.equal(4);
        expect(result[0].name).to.equal('package-name1-1.1.0.tgz');
        expect(result[1].name).to.equal('package-name1-1.0.0.tgz');
        expect(result[2].name).to.equal('package-name1-1.3.0.tgz');
        expect(result[3].name).to.equal('package-name1-1.2.0.tgz');
    });

    it('should filter items based on unique name', function () {
        const items = [
            {
                name: 'package-name1-1.0.0.tgz',
                date: '2020-04-02T08:31:49.211Z'
            },
            {
                name: 'package-name1-1.0.0.tgz',
                date: '2020-04-01T08:31:49.211Z'
            },
            {
                name: 'package-name1-1.2.0.tgz',
                date: '2020-04-04T08:31:49.211Z'
            },
            {
                name: 'package-name1-1.0.0.tgz',
                date: '2020-04-02T09:30:49.211Z'
            }
        ];

        const result = services._filterKeepUnique(items);
        expect(result.length).to.equal(2);
        expect(result[0].name).to.equal('package-name1-1.0.0.tgz');
        expect(result[0].date).to.equal('2020-04-02T08:31:49.211Z');
        expect(result[1].name).to.equal('package-name1-1.2.0.tgz');
        expect(result[1].date).to.equal('2020-04-04T08:31:49.211Z');
    });

});
