const express = require("express");

const PORT = "3000";
const app = express();
const ENCODING_UTF8 = 'utf-8';
const HEADER_CONTENT_TYPE = "Content-Type";
const CONTENT_TYPE_HTML = `text/html; charset=${ENCODING_UTF8}`;
const CONTENT_TYPE_JSON = `application/json; charset=${ENCODING_UTF8}`;
const CONTENT_TYPE_TEXT = `text/plain; charset=${ENCODING_UTF8}`;

/**
 * Simulate successful login.
 */
app.post("/api/login", (req, res) => {
    // Return the data.
    res.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON);
    res.status(200);
    res.send('{"status":"ok"}');
});

/**
 * Simulate successful logout.
 */
app.get("/api/logout", (req, res) => {
    // Return the data.
    res.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON);
    res.status(200);
    res.send('{"status":"ok"}');
});

/**
 * Return version.
 */
app.get("/api/version", (req, res) => {
    // Return the data.
    res.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_TEXT);
    res.status(200);
    res.send('DEV');
});

/**
 * Start the build and return the Jenkins job URL on success.
 */
app.get("/api/startBuild", (req, res) => {
    // Return the data.
    res.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_TEXT);
    res.status(200);
    res.send('https://jenkins.io/');
});

/**
 * Return the list of assets.
 */
app.get("/api/assets", (req, res) => {
    // Return the data.
    res.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON);
    res.status(200);
    res.send(
        JSON.stringify({
            assets: [
                {
                    name: "medewerkersportaal-mpin1003-1.0.1-SNAPSHOT.200",
                    created: "2020-04-01T08:31:49.211Z"
                },
                {
                    name: "medewerkersportaal-mpin989-1.0.1-SNAPSHOT.2",
                    created: "2020-04-02T08:31:49.211Z"
                },
                {
                    name: "medewerkersportaal-mpin1016-1.1.2-SNAPSHOT.12",
                    created: "2020-04-03T08:31:49.211Z"
                }
            ]
        })
    );
});

/**
 * Index file, just show some general info about this stub server file.
 * Also show it for all URLs that do not match.
 */
app.get("*", (req, res) => {

    res.header(HEADER_CONTENT_TYPE, CONTENT_TYPE_HTML);

    let status = 200;
    let body = "";

    // Make it clear that the requested resource does not exist.
    if (req.originalUrl && req.originalUrl !== '/') {
        status = 404;
        body += `<p style="color:red">404 - Requested resource not found "${req.originalUrl}"</p>`;
    }

    body += `
<p>This is a stub server. <br />
  See for details: <strong>${__filename}</strong>
</p>`;

    res.send(status, body);
});

const server = app.listen(PORT, () => {
    // eslint-disable-next-line no-console
    console.log("Express stub-server listening on port " + server.address().port);
});
