/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.cli;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.javascript.CreateRunConfigurationUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.buildTools.npm.NpmScript;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationBuilder;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfigManager;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfiguration;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.cli.VueCliGeneratorQuestioningPanel;
import org.jetbrains.vuejs.cli.VueCliGeneratorSettingsPeer;
import org.jetbrains.vuejs.cli.VueCliRunningGeneratorController;
import org.jetbrains.vuejs.cli.VueCreateProjectProcess;
import org.jetbrains.vuejs.cli.VueProjectCreationState;
import org.jetbrains.vuejs.cli.VueRunningGeneratorListener;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0013J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\"\u001a\u00020\u0013R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/vuejs/cli/VueCliRunningGeneratorController;", "Lcom/intellij/openapi/Disposable;", "generationLocation", "Ljava/nio/file/Path;", "settings", "Lcom/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings;", "listener", "Lorg/jetbrains/vuejs/cli/VueRunningGeneratorListener;", "parentDisposable", "(Ljava/nio/file/Path;Lcom/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings;Lorg/jetbrains/vuejs/cli/VueRunningGeneratorListener;Lcom/intellij/openapi/Disposable;)V", "currentQuestion", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Question;", "process", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess;", "questionUi", "Lorg/jetbrains/vuejs/cli/VueCliGeneratorQuestioningPanel;", "state", "Lorg/jetbrains/vuejs/cli/VueProjectCreationState;", "createListeningProgress", "", "project", "Lcom/intellij/openapi/project/Project;", "doneCallback", "Ljava/lang/Runnable;", "createNpmRunConfiguration", "dispose", "getPanel", "Ljavax/swing/JPanel;", "getVueCliVersion", "", "isFinished", "", "onNext", "setupWebpackConfigFile", "stopProcess", "intellij.vuejs"})
public final class VueCliRunningGeneratorController
implements Disposable {
    private volatile VueProjectCreationState state;
    private VueCreateProjectProcess.Question currentQuestion;
    private VueCreateProjectProcess process;
    private VueCliGeneratorQuestioningPanel questionUi;
    private final NpmPackageProjectGenerator.Settings settings;
    private final VueRunningGeneratorListener listener;

    private final Number getVueCliVersion() {
        NodePackage nodePackage = this.settings.myPackage;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodePackage, (String)"settings.myPackage");
        String string = nodePackage.getSystemIndependentPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"settings.myPackage.systemIndependentPath");
        String vueCliPackage = string;
        return StringsKt.endsWith$default((String)vueCliPackage, (String)"/@vue/cli", (boolean)false, (int)2, null) ? (Number)3 : (Number)(StringsKt.endsWith$default((String)vueCliPackage, (String)"/vue-cli", (boolean)false, (int)2, null) ? (Number)2 : (Number)0);
    }

    private final void createListeningProgress(Project project, Runnable doneCallback, Path generationLocation) {
        if (this.process == null) {
            return;
        }
        Task.Backgroundable task2 = new Task.Backgroundable(this, project, doneCallback, generationLocation, project, VueBundle.Companion.message("vue.project.generator.progress.task.name.dots", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            final /* synthetic */ VueCliRunningGeneratorController this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Runnable $doneCallback;
            final /* synthetic */ Path $generationLocation;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                VueCreateProjectProcess vueCreateProjectProcess = VueCliRunningGeneratorController.access$getProcess$p(this.this$0);
                if (vueCreateProjectProcess == null) {
                    Intrinsics.throwNpe();
                }
                vueCreateProjectProcess.waitForProcessTermination(indicator);
            }

            public void onFinished() {
                ReadAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                    final /* synthetic */ createListeningProgress.task.1 this$0;

                    public final void run() {
                        if (this.this$0.$project.isDisposed()) {
                            return;
                        }
                        this.this$0.$doneCallback.run();
                        JSRootConfiguration.getInstance((Project)this.this$0.$project).storeLanguageLevelAndUpdateCaches(JSLanguageLevel.ES6);
                        VueCliRunningGeneratorController.access$setupWebpackConfigFile(this.this$0.this$0, this.this$0.$project);
                        CreateRunConfigurationUtil.debugConfiguration((Project)this.this$0.$project, (int)8080);
                        VueCliRunningGeneratorController.access$createNpmRunConfiguration(this.this$0.this$0, this.this$0.$project);
                        LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)this.this$0.$generationLocation.toFile()), true, true, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                this.$doneCallback = $captured_local_variable$2;
                this.$generationLocation = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(task2);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)indicator);
    }

    private final void setupWebpackConfigFile(Project project) {
        String path;
        Number number = this.getVueCliVersion();
        String string = Intrinsics.areEqual((Object)number, (Object)3) ? Intrinsics.stringPlus((String)project.getBasePath(), (Object)"/node_modules/@vue/cli-service/webpack.config.js") : (path = Intrinsics.areEqual((Object)number, (Object)2) ? Intrinsics.stringPlus((String)project.getBasePath(), (Object)"/build/webpack.dev.conf.js") : null);
        if (path != null && new File(path).isFile()) {
            WebPackConfigManager.Companion.instance(project).loadState(new WebPackConfiguration(path));
        }
    }

    private final void createNpmRunConfiguration(Project project) {
        RunManager runManager = RunManager.Companion.getInstance(project);
        VirtualFile pkg = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)project.getBaseDir());
        if (pkg != null) {
            Object v5;
            Object e;
            Object object;
            String scriptName;
            Object object22;
            Iterable iterable;
            List npmScripts;
            block11: {
                Object object3;
                block10: {
                    Iterable iterable2;
                    NpmScriptsStructure npmScriptsStructure = NpmScriptsUtil.listTasks((Project)project, (VirtualFile)pkg);
                    Intrinsics.checkExpressionValueIsNotNull((Object)npmScriptsStructure, (String)"NpmScriptsUtil.listTasks(project, pkg)");
                    List list = npmScripts = npmScriptsStructure.getScripts();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"npmScripts");
                    iterable = iterable2 = (Iterable)list;
                    for (Object object22 : iterable) {
                        NpmScript it = (NpmScript)object22;
                        boolean bl = false;
                        NpmScript npmScript = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)npmScript, (String)"it");
                        if (!(Intrinsics.areEqual((Object)npmScript.getName(), (Object)"start") || Intrinsics.areEqual((Object)it.getName(), (Object)"serve") || Intrinsics.areEqual((Object)it.getName(), (Object)"dev"))) continue;
                        object3 = object22;
                        break block10;
                    }
                    object3 = null;
                }
                if (object3 == null && Intrinsics.areEqual((Object)this.getVueCliVersion(), (Object)3) ^ true) {
                    return;
                }
                scriptName = "serve";
                iterable = npmScripts;
                object = iterable;
                object22 = object.iterator();
                while (object22.hasNext()) {
                    e = object22.next();
                    NpmScript it = (NpmScript)e;
                    boolean bl = false;
                    NpmScript npmScript = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)npmScript, (String)"it");
                    if (!Intrinsics.areEqual((Object)npmScript.getName(), (Object)"start")) continue;
                    v5 = e;
                    break block11;
                }
                v5 = null;
            }
            if (v5 != null) {
                scriptName = "start";
            } else {
                Object v7;
                block12: {
                    iterable = npmScripts;
                    object = iterable;
                    object22 = object.iterator();
                    while (object22.hasNext()) {
                        e = object22.next();
                        NpmScript it = (NpmScript)e;
                        boolean bl = false;
                        NpmScript npmScript = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)npmScript, (String)"it");
                        if (!(Intrinsics.areEqual((Object)npmScript.getName(), (Object)"start") || Intrinsics.areEqual((Object)it.getName(), (Object)"serve"))) continue;
                        v7 = e;
                        break block12;
                    }
                    v7 = null;
                }
                if (v7 == null) {
                    Object v9;
                    block13: {
                        iterable = npmScripts;
                        object = iterable;
                        object22 = object.iterator();
                        while (object22.hasNext()) {
                            e = object22.next();
                            NpmScript it = (NpmScript)e;
                            boolean bl = false;
                            NpmScript npmScript = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)npmScript, (String)"it");
                            if (!Intrinsics.areEqual((Object)npmScript.getName(), (Object)"dev")) continue;
                            v9 = e;
                            break block13;
                        }
                        v9 = null;
                    }
                    if (v9 != null) {
                        scriptName = "dev";
                    }
                }
            }
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = new NpmRunConfigurationBuilder(project).createRunConfiguration("npm " + scriptName, null, pkg.getPath(), ContainerUtil.newHashMap((Pair)Pair.pair((Object)"run-script", (Object)scriptName), (Pair[])new Pair[0]));
            Intrinsics.checkExpressionValueIsNotNull((Object)runnerAndConfigurationSettings, (String)"NpmRunConfigurationBuild\u2026un-script\", scriptName)))");
            RunnerAndConfigurationSettings startConfiguration = runnerAndConfigurationSettings;
            runManager.setSelectedConfiguration(startConfiguration);
        }
    }

    public final boolean isFinished() {
        return this.state == VueProjectCreationState.QuestionsFinished || this.state == VueProjectCreationState.Error;
    }

    @NotNull
    public final JPanel getPanel() {
        VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel = this.questionUi;
        if (vueCliGeneratorQuestioningPanel == null) {
            Intrinsics.throwNpe();
        }
        return vueCliGeneratorQuestioningPanel.getPanel();
    }

    public final void onNext() {
        if (this.state != VueProjectCreationState.Process) {
            if (this.state == VueProjectCreationState.User) {
                boolean bl;
                boolean bl2 = bl = this.currentQuestion != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.listener.disableNext(null);
                VueCreateProjectProcess.Question question = this.currentQuestion;
                if (question == null) {
                    Intrinsics.throwNpe();
                }
                if (question.getType() == VueCreateProjectProcess.QuestionType.Checkbox) {
                    VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel = this.questionUi;
                    if (vueCliGeneratorQuestioningPanel == null) {
                        Intrinsics.throwNpe();
                    }
                    List<String> list = vueCliGeneratorQuestioningPanel.getCheckboxAnswer();
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    List<String> answer = list;
                    VueCreateProjectProcess vueCreateProjectProcess = this.process;
                    if (vueCreateProjectProcess == null) {
                        Intrinsics.throwNpe();
                    }
                    vueCreateProjectProcess.answer(answer);
                } else {
                    VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel = this.questionUi;
                    if (vueCliGeneratorQuestioningPanel == null) {
                        Intrinsics.throwNpe();
                    }
                    String string = vueCliGeneratorQuestioningPanel.getAnswer();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String answer = string;
                    VueCreateProjectProcess vueCreateProjectProcess = this.process;
                    if (vueCreateProjectProcess == null) {
                        Intrinsics.throwNpe();
                    }
                    vueCreateProjectProcess.answer(answer);
                }
                this.state = VueProjectCreationState.Process;
                VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel = this.questionUi;
                if (vueCliGeneratorQuestioningPanel == null) {
                    Intrinsics.throwNpe();
                }
                vueCliGeneratorQuestioningPanel.waitForNextQuestion();
            } else if (this.state == VueProjectCreationState.QuestionsFinished) {
                this.listener.cancelCloseUI();
            }
        }
    }

    public void dispose() {
        this.stopProcess();
    }

    public final void stopProcess() {
        block1: {
            if (this.state == VueProjectCreationState.QuestionsFinished) break block1;
            VueCreateProjectProcess vueCreateProjectProcess = this.process;
            if (vueCreateProjectProcess != null) {
                vueCreateProjectProcess.cancel();
            }
        }
    }

    public VueCliRunningGeneratorController(final @NotNull Path generationLocation, @NotNull NpmPackageProjectGenerator.Settings settings, @NotNull VueRunningGeneratorListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)generationLocation, (String)"generationLocation");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.settings = settings;
        this.listener = listener2;
        this.state = VueProjectCreationState.Starting;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.state = VueProjectCreationState.Process;
        Object object = this.settings.getUserData(VueCliGeneratorSettingsPeer.Companion.getTEMPLATE_KEY$intellij_vuejs());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"settings.getUserData(Vue\u2026tingsPeer.TEMPLATE_KEY)!!");
        String templateName = (String)object;
        String projectName = ((Object)generationLocation.getFileName()).toString();
        boolean isOldPackage = this.settings.myPackage.nameMatches("vue-cli");
        this.questionUi = new VueCliGeneratorQuestioningPanel(isOldPackage, templateName, projectName, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (state == VueProjectCreationState.User) {
                    if (it) {
                        listener.enableNext();
                    } else {
                        listener.disableNext(null);
                    }
                }
            }
        }));
        Path path = generationLocation.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"generationLocation.parent");
        NodeJsInterpreterRef nodeJsInterpreterRef = this.settings.myInterpreterRef;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"settings.myInterpreterRef");
        NodePackage nodePackage = this.settings.myPackage;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodePackage, (String)"settings.myPackage");
        VueCreateProjectProcess vueCreateProjectProcess = this.process = new VueCreateProjectProcess(path, projectName, templateName, nodeJsInterpreterRef, nodePackage, this);
        if (vueCreateProjectProcess == null) {
            Intrinsics.throwNpe();
        }
        vueCreateProjectProcess.setListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        VueCreateProjectProcess.State processState;
                        if (state != VueProjectCreationState.Process) {
                            return;
                        }
                        VueCreateProjectProcess vueCreateProjectProcess = process;
                        if (vueCreateProjectProcess == null) {
                            Intrinsics.throwNpe();
                        }
                        if (VueProjectCreationState.Error == (processState = vueCreateProjectProcess.getState()).getProcessState()) {
                            VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel = questionUi;
                            if (vueCliGeneratorQuestioningPanel == null) {
                                Intrinsics.throwNpe();
                            }
                            vueCliGeneratorQuestioningPanel.error();
                            listener.error(processState.getGlobalProblem());
                            state = VueProjectCreationState.Error;
                            VueCreateProjectProcess vueCreateProjectProcess2 = process;
                            if (vueCreateProjectProcess2 == null) {
                                Intrinsics.throwNpe();
                            }
                            vueCreateProjectProcess2.setListener((Function0<Unit>)((Function0)null));
                            VueCreateProjectProcess vueCreateProjectProcess3 = process;
                            if (vueCreateProjectProcess3 == null) {
                                Intrinsics.throwNpe();
                            }
                            vueCreateProjectProcess3.cancel();
                        } else if (VueProjectCreationState.QuestionsFinished == processState.getProcessState() || VueProjectCreationState.Finished == processState.getProcessState()) {
                            state = VueProjectCreationState.QuestionsFinished;
                            Function1 callback2 = (Function1)new Function1<Project, Unit>(this){
                                final /* synthetic */ 1 this$0;

                                public final void invoke(@NotNull Project project) {
                                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                                    Object object = BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"BackgroundTaskUtil.syncP\u2026FileChangeListener.TOPIC)");
                                    BatchFileChangeListener publisher = (BatchFileChangeListener)object;
                                    publisher.batchChangeStarted(project, VueBundle.Companion.message("vue.project.generator.progress.task.name", new Object[0]));
                                    VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)project.getBaseDir());
                                    Runnable runnable = PackageJsonDependenciesExternalUpdateManager.getInstance((Project)project).externalUpdateStarted(packageJson, null);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"PackageJsonDependenciesE\u2026tarted(packageJson, null)");
                                    Runnable doneCallback = runnable;
                                    StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(this, project, publisher, doneCallback){
                                        final /* synthetic */ callback.1 this$0;
                                        final /* synthetic */ Project $project;
                                        final /* synthetic */ BatchFileChangeListener $publisher;
                                        final /* synthetic */ Runnable $doneCallback;

                                        public void run() {
                                            VueCliRunningGeneratorController.access$createListeningProgress(this, this.$project, new Runnable(this){
                                                final /* synthetic */ callback.1 this$0;

                                                public final void run() {
                                                    this.this$0.$publisher.batchChangeCompleted(this.this$0.$project);
                                                    this.this$0.$doneCallback.run();
                                                }
                                                {
                                                    this.this$0 = var1_1;
                                                }
                                            }, generationLocation);
                                        }
                                        {
                                            this.this$0 = $outer;
                                            this.$project = $captured_local_variable$1;
                                            this.$publisher = $captured_local_variable$2;
                                            this.$doneCallback = $captured_local_variable$3;
                                        }
                                    });
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            };
                            listener.finishedQuestionsCloseUI((Function1<? super Project, Unit>)callback2);
                        } else if (VueProjectCreationState.Process == processState.getProcessState()) {
                            String error;
                            currentQuestion = processState.getQuestion();
                            VueCreateProjectProcess.Question question = processState.getQuestion();
                            String string = error = question != null ? question.getValidationError() : null;
                            if (error != null) {
                                listener.disableNext(error);
                                VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel = questionUi;
                                if (vueCliGeneratorQuestioningPanel == null) {
                                    Intrinsics.throwNpe();
                                }
                                vueCliGeneratorQuestioningPanel.activateUi();
                            } else {
                                listener.disableNext("");
                                VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel = questionUi;
                                if (vueCliGeneratorQuestioningPanel == null) {
                                    Intrinsics.throwNpe();
                                }
                                VueCreateProjectProcess.Question question2 = processState.getQuestion();
                                if (question2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                vueCliGeneratorQuestioningPanel.question(question2);
                            }
                            state = VueProjectCreationState.User;
                            listener.enableNext();
                        }
                    }
                }, ModalityState.any(), (Condition)new Condition<Boolean>(){

                    public final boolean value(Boolean it) {
                        return state == VueProjectCreationState.QuestionsFinished || state == VueProjectCreationState.Error;
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ void access$setProcess$p(VueCliRunningGeneratorController $this, VueCreateProjectProcess vueCreateProjectProcess) {
        $this.process = vueCreateProjectProcess;
    }

    public static final /* synthetic */ void access$setupWebpackConfigFile(VueCliRunningGeneratorController $this, Project project) {
        $this.setupWebpackConfigFile(project);
    }

    public static final /* synthetic */ void access$createNpmRunConfiguration(VueCliRunningGeneratorController $this, Project project) {
        $this.createNpmRunConfiguration(project);
    }

    public static final /* synthetic */ void access$setQuestionUi$p(VueCliRunningGeneratorController $this, VueCliGeneratorQuestioningPanel vueCliGeneratorQuestioningPanel) {
        $this.questionUi = vueCliGeneratorQuestioningPanel;
    }

    public static final /* synthetic */ void access$createListeningProgress(VueCliRunningGeneratorController $this, Project project, Runnable doneCallback, Path generationLocation) {
        $this.createListeningProgress(project, doneCallback, generationLocation);
    }

    public static final /* synthetic */ VueCreateProjectProcess.Question access$getCurrentQuestion$p(VueCliRunningGeneratorController $this) {
        return $this.currentQuestion;
    }
}

