/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.cli;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.socket.RpcBinaryRequestHandler;
import org.jetbrains.vuejs.cli.VueCreateProjectProcess;
import org.jetbrains.vuejs.cli.VueProjectCreationState;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\n\u0018\u0000 >2\u00020\u0001:\u0005=>?@AB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010 \u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0005J\u0014\u0010 \u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0006\u0010$\u001a\u00020\u0011J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0002\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00182\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u0010,\u001a\u0004\u0018\u00010\u001c2\u0006\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010/\u001a\u00020\u0011H\u0016J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J\u0006\u00102\u001a\u000203J\u001a\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u000206H\u0002J\u0014\u00107\u001a\u0004\u0018\u0001082\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u00109\u001a\u00020\u0011H\u0002J\b\u0010:\u001a\u00020\u0011H\u0002J\b\u0010;\u001a\u00020\u0011H\u0002J\u000e\u0010<\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess;", "Lcom/intellij/openapi/Disposable;", "folder", "Ljava/nio/file/Path;", "projectName", "", "templateName", "interpreterRef", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "vuePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "parentDisposable", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;Lcom/intellij/javascript/nodejs/util/NodePackage;Lcom/intellij/openapi/Disposable;)V", "error", "lastMessage", "listener", "Lkotlin/Function0;", "", "getListener", "()Lkotlin/jvm/functions/Function0;", "setListener", "(Lkotlin/jvm/functions/Function0;)V", "processHandlerRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/execution/process/KillableProcessHandler;", "processState", "Lorg/jetbrains/vuejs/cli/VueProjectCreationState;", "questionRef", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Question;", "rpcServer", "Lorg/jetbrains/io/jsonRpc/JsonRpcServer;", "serverDisposer", "answer", "", "attachGenerationProcessListener", "processHandler", "cancel", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Ljava/io/File;", "interpreterPath", "createPeerVueCliProcess", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "deserializeQuestion", "serializedObject", "validationError", "dispose", "filterProgressText", "text", "getState", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$State;", "logProgress", "message", "", "reportError", "", "sendCancel", "startProcess", "stopProcess", "waitForProcessTermination", "Choice", "Companion", "Question", "QuestionType", "State", "intellij.vuejs"})
public final class VueCreateProjectProcess
implements Disposable {
    private final AtomicReference<KillableProcessHandler> processHandlerRef;
    private final AtomicReference<Question> questionRef;
    private volatile String error;
    private volatile VueProjectCreationState processState;
    private final Disposable serverDisposer;
    private final JsonRpcServer rpcServer;
    private volatile String lastMessage;
    @Nullable
    private volatile Function0<Unit> listener;
    private final Path folder;
    private final String projectName;
    private final String templateName;
    private final NodeJsInterpreterRef interpreterRef;
    private final NodePackage vuePackage;
    private static final String DOMAIN = "vue-create-project";
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final Function0<Unit> getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable Function0<Unit> function0) {
        this.listener = function0;
    }

    private final void startProcess() {
        Task.Backgroundable task2 = new Task.Backgroundable(this, null, "Starting Vue CLI...", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            final /* synthetic */ VueCreateProjectProcess this$0;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                KillableProcessHandler handler = VueCreateProjectProcess.access$createPeerVueCliProcess(this.this$0, indicator);
                if (handler == null) {
                    Disposer.dispose((Disposable)VueCreateProjectProcess.access$getServerDisposer$p(this.this$0));
                } else {
                    VueCreateProjectProcess.access$getProcessHandlerRef$p(this.this$0).set(handler);
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] projectArray2 = projectArray;
        if (projectArray2.length == 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ApplicationManager.getApplication().executeOnPooledThread(new Runnable(task2){
                final /* synthetic */ Task.Backgroundable $task;

                public final void run() {
                    this.$task.run((ProgressIndicator)new EmptyProgressIndicator());
                }
                {
                    this.$task = backgroundable;
                }
            }), (String)"ApplicationManager.getAp\u2026ptyProgressIndicator()) }");
        } else {
            ProgressManager.getInstance().run((Task)task2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Question deserializeQuestion(String serializedObject, String validationError) {
        Object object;
        JsonArray choices;
        JsonElement jsonElement = new JsonParser().parse(serializedObject);
        if (!(jsonElement instanceof JsonObject)) {
            jsonElement = null;
        }
        JsonObject jsonObject = (JsonObject)jsonElement;
        if (jsonObject == null) {
            return null;
        }
        JsonObject obj = jsonObject;
        Object object2 = obj.get("type");
        if (object2 == null || (object2 = object2.getAsString()) == null) {
            return null;
        }
        Object type = object2;
        QuestionType questionType = QuestionType.Companion.read((String)type);
        if (questionType == null) {
            return null;
        }
        QuestionType questionType2 = questionType;
        List choicesList = new ArrayList();
        JsonElement jsonElement2 = obj.get("choices");
        Object object3 = choices = jsonElement2 != null ? jsonElement2.getAsJsonArray() : null;
        if (choices != null) {
            int n = 0;
            int n2 = choices.size();
            while (n < n2) {
                JsonObject choice;
                void i;
                JsonElement jsonElement3 = choices.get((int)i);
                if (!(jsonElement3 instanceof JsonObject)) {
                    jsonElement3 = null;
                }
                if ((JsonObject)jsonElement3 == null) {
                    return null;
                }
                Object object4 = choice.get("name");
                if (object4 == null || (object4 = object4.getAsString()) == null) {
                    return null;
                }
                Object name = object4;
                Object object5 = choice.get("value");
                if (object5 == null || (object5 = object5.getAsString()) == null) {
                    return null;
                }
                Object value = object5;
                choicesList.add(new Choice((String)name, (String)value));
                ++i;
            }
        }
        if ((object = obj.get("message")) == null || (object = object.getAsString()) == null) {
            return null;
        }
        Object message = object;
        Object object6 = obj.get("default");
        if (object6 == null || (object6 = object6.getAsString()) == null) {
            object6 = "";
        }
        Object defaultVal = object6;
        return new Question(questionType2, (String)message, (String)defaultVal, choicesList, validationError);
    }

    private final void logProgress(String message, boolean error) {
        if (error) {
            LOG.info("From service: " + message);
        } else {
            LOG.debug("From service: " + message);
        }
    }

    static /* synthetic */ void logProgress$default(VueCreateProjectProcess vueCreateProjectProcess, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        vueCreateProjectProcess.logProgress(string, bl);
    }

    public final void waitForProcessTermination(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        KillableProcessHandler killableProcessHandler = this.processHandlerRef.get();
        if (killableProcessHandler == null) {
            return;
        }
        KillableProcessHandler handler = killableProcessHandler;
        String lastMessageCopy = this.lastMessage;
        if (lastMessageCopy != null) {
            indicator.setText(this.filterProgressText(lastMessageCopy));
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(this, indicator){
            final /* synthetic */ VueCreateProjectProcess this$0;
            final /* synthetic */ ProgressIndicator $indicator;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                boolean bl;
                block2: {
                    CharSequence $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
                    String string = event.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.text");
                    CharSequence charSequence = $receiver$iv = (CharSequence)string;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char element$iv;
                        char it = element$iv = charSequence.charAt(i);
                        boolean bl2 = false;
                        if (!Character.isLetter(it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                if (bl) {
                    String string = event.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.text");
                    this.$indicator.setText(VueCreateProjectProcess.access$filterProgressText(this.this$0, string));
                }
            }
            {
                this.this$0 = $outer;
                this.$indicator = $captured_local_variable$1;
            }
        });
        handler.waitFor();
    }

    private final String filterProgressText(String text) {
        String string;
        CharSequence $receiver$iv;
        StringBuilder sb = new StringBuilder();
        CharSequence charSequence = $receiver$iv = (CharSequence)text;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            if (it > '\u00ff') continue;
            sb.append(it);
        }
        String string2 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    private final KillableProcessHandler createPeerVueCliProcess(ProgressIndicator indicator) {
        ProcessOutput output;
        Path path = Paths.get(PathManager.getSystemPath(), "projectGenerators", "vue");
        File folder = path.toFile();
        if (Files.exists(path, new LinkOption[0])) {
            FileUtil.delete((File)folder);
        }
        if (!FileUtil.createDirectory((File)folder)) {
            return (KillableProcessHandler)this.reportError("Can not create service directory " + path);
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        NodeJsInterpreter nodeJsInterpreter = this.interpreterRef.resolveNotNull(projectManager.getDefaultProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreter, (String)"interpreterRef.resolveNo\u2026nstance().defaultProject)");
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.cast((NodeJsInterpreter)interpreter);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsLocalInterpreter, (String)"NodeJsLocalInterpreter.cast(interpreter)");
        NodeJsLocalInterpreter localInterpreter = nodeJsLocalInterpreter;
        indicator.setText("Installing packages to create a new Vue project...");
        ProjectManager projectManager2 = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager2, (String)"ProjectManager.getInstance()");
        NodePackage npmPkg = NpmManager.getInstance((Project)projectManager2.getDefaultProject()).getPackage(interpreter);
        GeneralCommandLine installCommandLine = null;
        if (npmPkg != null && npmPkg.isValid()) {
            GeneralCommandLine generalCommandLine = NpmUtil.createNpmCommandLine((File)folder, (NodeJsInterpreter)interpreter, (NodePackage)npmPkg, (NpmCommand)NpmCommand.ADD, (List)CollectionsKt.listOf((Object)"ij-rpc-client"));
            Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"NpmUtil.createNpmCommand\u2026 listOf(\"ij-rpc-client\"))");
            installCommandLine = generalCommandLine;
        } else {
            GeneralCommandLine generalCommandLine = NpmUtil.createNpmCommandLine(null, (File)folder, (NodeJsInterpreter)interpreter, (NpmCommand)NpmCommand.ADD, (List)CollectionsKt.listOf((Object)"ij-rpc-client"));
            Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"NpmUtil.createNpmCommand\u2026 listOf(\"ij-rpc-client\"))");
            installCommandLine = generalCommandLine;
        }
        ProcessOutput processOutput = output = new CapturingProcessHandler(installCommandLine).runProcess((int)TimeUnit.MINUTES.toMillis(5L), true);
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"output");
        if (processOutput.getExitCode() != 0) {
            return (KillableProcessHandler)this.reportError("Can not install 'ij-rpc-client': " + output.getStderr());
        }
        indicator.setText("Starting Vue CLI...");
        File file = folder;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"folder");
        String string = localInterpreter.getInterpreterSystemDependentPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localInterpreter.interpreterSystemDependentPath");
        GeneralCommandLine generalCommandLine = this.createCommandLine(file, string);
        if (generalCommandLine == null) {
            return (KillableProcessHandler)this.reportError("Can not run Vue project generation service");
        }
        GeneralCommandLine commandLine = generalCommandLine;
        KillableProcessHandler processHandler = null;
        try {
            processHandler = new KillableProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            return (KillableProcessHandler)this.reportError(e.getMessage());
        }
        this.attachGenerationProcessListener(processHandler);
        processHandler.startNotify();
        return processHandler;
    }

    private final void attachGenerationProcessListener(KillableProcessHandler processHandler) {
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(this){
            final /* synthetic */ VueCreateProjectProcess this$0;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                boolean bl;
                boolean isError;
                block4: {
                    CharSequence $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
                    isError = ProcessOutputType.isStderr(outputType);
                    if (VueCreateProjectProcess.access$getProcessState$p(this.this$0) == VueProjectCreationState.Starting && isError) {
                        VueCreateProjectProcess.access$setError$p(this.this$0, event.getText());
                        VueCreateProjectProcess.access$setProcessState$p(this.this$0, VueProjectCreationState.Error);
                        Function0<Unit> function0 = this.this$0.getListener();
                        if (function0 != null) {
                            Unit cfr_ignored_0 = (Unit)function0.invoke();
                        }
                    }
                    String string = event.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.text");
                    CharSequence charSequence = $receiver$iv = (CharSequence)string;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char element$iv;
                        char it = element$iv = charSequence.charAt(i);
                        boolean bl2 = false;
                        if (!Character.isLetter(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                if (bl) {
                    VueCreateProjectProcess.access$setLastMessage$p(this.this$0, event.getText());
                }
                String string = event.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.text");
                VueCreateProjectProcess.access$logProgress(this.this$0, string, isError);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                VueCreateProjectProcess.access$setProcessState$p(this.this$0, VueProjectCreationState.Finished);
                Function0<Unit> function0 = this.this$0.getListener();
                if (function0 != null) {
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
                Disposer.dispose((Disposable)this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final Void reportError(String message) {
        block0: {
            this.error = message;
            this.processState = VueProjectCreationState.Error;
            Function0<Unit> function0 = this.listener;
            if (function0 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        return null;
    }

    private final GeneralCommandLine createCommandLine(File folder, String interpreterPath) {
        File serviceFolder = JSLanguageServiceUtil.getPluginDirectory(this.getClass(), (String)"vueCliClient");
        if (serviceFolder == null) {
            LOG.info("Can not find generator script parent folder");
        }
        String targetName = "call-vue-cli-init.js";
        File file = serviceFolder;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"serviceFolder");
        Path targetPath = Paths.get(file.getPath(), targetName);
        if (!Files.exists(targetPath, new LinkOption[0])) {
            LOG.info("Can not find generator script");
            return null;
        }
        File copy = new File(folder, targetName);
        FileUtil.copyFileOrDir((File)targetPath.toFile(), (File)copy);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreterPath});
        commandLine.setWorkDirectory(this.folder.toFile());
        commandLine.addParameter(FileUtil.toSystemDependentName((String)copy.getPath()));
        BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)builtInServerManager, (String)"BuiltInServerManager.getInstance()");
        commandLine.addParameter(String.valueOf(builtInServerManager.getPort()));
        return commandLine;
    }

    @NotNull
    public final State getState() {
        boolean bl;
        VueProjectCreationState currentProcessState = this.processState;
        boolean bl2 = bl = currentProcessState != VueProjectCreationState.User;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (VueProjectCreationState.Starting == currentProcessState || VueProjectCreationState.Finished == currentProcessState || VueProjectCreationState.QuestionsFinished == currentProcessState) {
            return new State(currentProcessState, null, null);
        }
        if (VueProjectCreationState.Error == currentProcessState) {
            return new State(currentProcessState, this.error, null);
        }
        return new State(currentProcessState, null, this.questionRef.get());
    }

    public final void answer(@NotNull String answer) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)answer, (String)"answer");
        boolean bl2 = bl = this.questionRef.get() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.rpcServer.send(DOMAIN, "answer", new Object[]{answer});
    }

    /*
     * WARNING - void declaration
     */
    public final void answer(@NotNull List<String> answer) {
        String[] stringArray;
        void $receiver$iv;
        Object[] objectArray;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(answer, (String)"answer");
        boolean bl2 = bl = this.questionRef.get() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Collection collection = answer;
        int n = 0;
        Object[] objectArray2 = objectArray = new Object[1];
        String string = "answerCheckbox";
        String string2 = DOMAIN;
        JsonRpcServer jsonRpcServer = this.rpcServer;
        void thisCollection$iv = $receiver$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray[n] = stringArray = stringArray2;
        jsonRpcServer.send(string2, string, objectArray2);
    }

    public final void cancel() {
        this.sendCancel();
        this.stopProcess();
        Disposer.dispose((Disposable)this);
    }

    private final void sendCancel() {
        this.rpcServer.send(DOMAIN, "cancel", new Object[0]);
    }

    public void dispose() {
        VueCreateProjectProcess.logProgress$default(this, "Dispose called", false, 2, null);
        this.stopProcess();
    }

    private final void stopProcess() {
        if (this.processState != VueProjectCreationState.QuestionsFinished && this.processState != VueProjectCreationState.Finished) {
            KillableProcessHandler handler;
            KillableProcessHandler killableProcessHandler = handler = this.processHandlerRef.get();
            if (killableProcessHandler != null) {
                killableProcessHandler.destroyProcess();
            }
            this.processState = VueProjectCreationState.Finished;
        }
    }

    public VueCreateProjectProcess(@NotNull Path folder, @NotNull String projectName, @NotNull String templateName, @NotNull NodeJsInterpreterRef interpreterRef, @NotNull NodePackage vuePackage, @Nullable Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        Intrinsics.checkParameterIsNotNull((Object)interpreterRef, (String)"interpreterRef");
        Intrinsics.checkParameterIsNotNull((Object)vuePackage, (String)"vuePackage");
        this.folder = folder;
        this.projectName = projectName;
        this.templateName = templateName;
        this.interpreterRef = interpreterRef;
        this.vuePackage = vuePackage;
        this.processHandlerRef = new AtomicReference();
        this.questionRef = new AtomicReference();
        this.processState = VueProjectCreationState.Starting;
        this.serverDisposer = serverDisposer.1.INSTANCE;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
        Disposer.register((Disposable)this, (Disposable)this.serverDisposer);
        JsonRpcServer jsonRpcServer = RpcBinaryRequestHandler.getRpcServerInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonRpcServer, (String)"RpcBinaryRequestHandler.getRpcServerInstance()");
        this.rpcServer = jsonRpcServer;
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.createConstantValue((Object)new Object(){

            public final void question(@NotNull String serializedObject, @Nullable String validationError) {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
                    processState = VueProjectCreationState.Process;
                    Question question = this.deserializeQuestion(serializedObject, validationError);
                    if (question == null) {
                        Companion.getLOG().info("Vue Create Project: Can not parse question: " + serializedObject);
                        error = "Can not parse question: " + serializedObject;
                        processState = VueProjectCreationState.Error;
                        Function0<Unit> function0 = this.getListener();
                        if (function0 != null) {
                            Unit cfr_ignored_0 = (Unit)function0.invoke();
                        }
                        return;
                    }
                    questionRef.set(question);
                    Function0<Unit> function0 = this.getListener();
                    if (function0 == null) break block2;
                    Unit cfr_ignored_1 = (Unit)function0.invoke();
                }
            }

            public final void error(@NotNull String message) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    error = message;
                    processState = VueProjectCreationState.Error;
                    Function0<Unit> function0 = this.getListener();
                    if (function0 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
            }

            public final void questionsFinished() {
                block0: {
                    VueCreateProjectProcess.logProgress$default(this, "questions finished", false, 2, null);
                    processState = VueProjectCreationState.QuestionsFinished;
                    this.sendCancel();
                    Disposer.dispose((Disposable)serverDisposer);
                    Function0<Unit> function0 = this.getListener();
                    if (function0 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
            }

            public final void notifyStarted() {
                VueCreateProjectProcess.logProgress$default(this, "notify started", false, 2, null);
                Path packagePath = Paths.get(vuePackage.getSystemDependentPath(), new String[0]);
                JsonRpcServer jsonRpcServer = rpcServer;
                Object[] objectArray = new Object[4];
                Path path = packagePath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"packagePath");
                objectArray[0] = ((Object)path.getParent().normalize()).toString();
                objectArray[1] = ((Object)packagePath.getFileName()).toString();
                objectArray[2] = templateName;
                objectArray[3] = projectName;
                jsonRpcServer.send(VueCreateProjectProcess.DOMAIN, "start", objectArray);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)notNullLazyValue, (String)"NotNullLazyValue.createC\u2026ojectName)\n      }\n    })");
        this.rpcServer.registerDomain(DOMAIN, notNullLazyValue, false, this.serverDisposer);
        this.startProcess();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(VueCreateProjectProcess.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(VueCr\u2026ojectProcess::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ KillableProcessHandler access$createPeerVueCliProcess(VueCreateProjectProcess $this, ProgressIndicator indicator) {
        return $this.createPeerVueCliProcess(indicator);
    }

    public static final /* synthetic */ AtomicReference access$getProcessHandlerRef$p(VueCreateProjectProcess $this) {
        return $this.processHandlerRef;
    }

    public static final /* synthetic */ String access$filterProgressText(VueCreateProjectProcess $this, String text) {
        return $this.filterProgressText(text);
    }

    public static final /* synthetic */ VueProjectCreationState access$getProcessState$p(VueCreateProjectProcess $this) {
        return $this.processState;
    }

    public static final /* synthetic */ String access$getError$p(VueCreateProjectProcess $this) {
        return $this.error;
    }

    public static final /* synthetic */ String access$getLastMessage$p(VueCreateProjectProcess $this) {
        return $this.lastMessage;
    }

    public static final /* synthetic */ void access$setLastMessage$p(VueCreateProjectProcess $this, String string) {
        $this.lastMessage = string;
    }

    public static final /* synthetic */ void access$logProgress(VueCreateProjectProcess $this, String message, boolean error) {
        $this.logProgress(message, error);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$State;", "", "processState", "Lorg/jetbrains/vuejs/cli/VueProjectCreationState;", "globalProblem", "", "question", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Question;", "(Lorg/jetbrains/vuejs/cli/VueProjectCreationState;Ljava/lang/String;Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Question;)V", "getGlobalProblem", "()Ljava/lang/String;", "getProcessState", "()Lorg/jetbrains/vuejs/cli/VueProjectCreationState;", "getQuestion", "()Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Question;", "intellij.vuejs"})
    public static final class State {
        @NotNull
        private final VueProjectCreationState processState;
        @Nullable
        private final String globalProblem;
        @Nullable
        private final Question question;

        @NotNull
        public final VueProjectCreationState getProcessState() {
            return this.processState;
        }

        @Nullable
        public final String getGlobalProblem() {
            return this.globalProblem;
        }

        @Nullable
        public final Question getQuestion() {
            return this.question;
        }

        public State(@NotNull VueProjectCreationState processState, @Nullable String globalProblem, @Nullable Question question) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)processState), (String)"processState");
            this.processState = processState;
            this.globalProblem = globalProblem;
            this.question = question;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Question;", "", "type", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$QuestionType;", "message", "", "defaultVal", "choices", "", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Choice;", "validationError", "(Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$QuestionType;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getChoices", "()Ljava/util/List;", "getDefaultVal", "()Ljava/lang/String;", "getMessage", "getType", "()Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$QuestionType;", "getValidationError", "intellij.vuejs"})
    public static final class Question {
        @NotNull
        private final QuestionType type;
        @NotNull
        private final String message;
        @NotNull
        private final String defaultVal;
        @NotNull
        private final List<Choice> choices;
        @Nullable
        private final String validationError;

        @NotNull
        public final QuestionType getType() {
            return this.type;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getDefaultVal() {
            return this.defaultVal;
        }

        @NotNull
        public final List<Choice> getChoices() {
            return this.choices;
        }

        @Nullable
        public final String getValidationError() {
            return this.validationError;
        }

        public Question(@NotNull QuestionType type, @NotNull String message, @NotNull String defaultVal, @NotNull List<Choice> choices, @Nullable String validationError) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)defaultVal, (String)"defaultVal");
            Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
            this.type = type;
            this.message = message;
            this.defaultVal = defaultVal;
            this.choices = choices;
            this.validationError = validationError;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Choice;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "intellij.vuejs"})
    public static final class Choice {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public Choice(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$QuestionType;", "", "(Ljava/lang/String;I)V", "Input", "Confirm", "List", "Checkbox", "Companion", "intellij.vuejs"})
    public static final class QuestionType
    extends Enum<QuestionType> {
        public static final /* enum */ QuestionType Input;
        public static final /* enum */ QuestionType Confirm;
        public static final /* enum */ QuestionType List;
        public static final /* enum */ QuestionType Checkbox;
        private static final /* synthetic */ QuestionType[] $VALUES;
        public static final Companion Companion;

        static {
            QuestionType[] questionTypeArray = new QuestionType[4];
            QuestionType[] questionTypeArray2 = questionTypeArray;
            questionTypeArray[0] = Input = new QuestionType();
            questionTypeArray[1] = Confirm = new QuestionType();
            questionTypeArray[2] = List = new QuestionType();
            questionTypeArray[3] = Checkbox = new QuestionType();
            $VALUES = questionTypeArray;
            Companion = new Companion(null);
        }

        public static QuestionType[] values() {
            return (QuestionType[])$VALUES.clone();
        }

        public static QuestionType valueOf(String string) {
            return Enum.valueOf(QuestionType.class, string);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$QuestionType$Companion;", "", "()V", "read", "Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$QuestionType;", "value", "", "intellij.vuejs"})
        public static final class Companion {
            @Nullable
            public final QuestionType read(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                if (Intrinsics.areEqual((Object)"input", (Object)value)) {
                    return Input;
                }
                if (Intrinsics.areEqual((Object)"confirm", (Object)value)) {
                    return Confirm;
                }
                if (Intrinsics.areEqual((Object)"list", (Object)value)) {
                    return List;
                }
                if (Intrinsics.areEqual((Object)"checkbox", (Object)value)) {
                    return Checkbox;
                }
                return null;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/cli/VueCreateProjectProcess$Companion;", "", "()V", "DOMAIN", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vuejs"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

