/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.index;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueFileType;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.index.VueIndexBase;
import org.jetbrains.vuejs.index.VueIndexData;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a@\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u001a(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\"0!\u001a\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d\u001a\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(\u001a\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001d\u001a\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001d\u001a\u0010\u0010+\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a2\u0010,\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\"0!\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"BOOTSTRAP_VUE", "", "DELIMITER", "DIRECTIVES", "EXTENDS", "GLOBAL", "GLOBAL$annotations", "()V", "GLOBAL_BINDING_MARK", "INDEXED_ACCESS_HINT", "LOCAL", "MIXINS", "NAME", "SHARDS_VUE", "VUE", "VUETIFY", "VUE_CLASS_COMPONENT", "createImplicitElement", "Lcom/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl;", "name", "provider", "Lcom/intellij/psi/PsiElement;", "indexKey", "nameType", "descriptor", "isGlobal", "", "getForAllKeys", "", "Lcom/intellij/lang/javascript/psi/stubs/JSImplicitElement;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "key", "Lcom/intellij/psi/stubs/StubIndexKey;", "Lcom/intellij/lang/javascript/psi/JSImplicitElementProvider;", "getVueIndexData", "Lorg/jetbrains/vuejs/index/VueIndexData;", "element", "hasVue", "project", "Lcom/intellij/openapi/project/Project;", "hasVueClassComponentLibrary", "isGlobalExact", "normalizeNameForIndex", "resolve", "intellij.vuejs"})
public final class VueIndexKt {
    @NotNull
    public static final String VUE = "vue";
    @NotNull
    public static final String VUETIFY = "vuetify";
    @NotNull
    public static final String BOOTSTRAP_VUE = "bootstrap-vue";
    @NotNull
    public static final String SHARDS_VUE = "shards-vue";
    @NotNull
    public static final String GLOBAL = "global";
    @NotNull
    public static final String LOCAL = "local";
    @NotNull
    public static final String MIXINS = "mixins";
    @NotNull
    public static final String EXTENDS = "extends";
    @NotNull
    public static final String DIRECTIVES = "directives";
    @NotNull
    public static final String NAME = "name";
    @NotNull
    public static final String GLOBAL_BINDING_MARK = "*";
    @NotNull
    public static final String VUE_CLASS_COMPONENT = "vue-class-component";
    private static final String INDEXED_ACCESS_HINT = "[]";
    @NotNull
    public static final String DELIMITER = "#";

    public static /* synthetic */ void GLOBAL$annotations() {
    }

    @NotNull
    public static final Collection<JSImplicitElement> getForAllKeys(@NotNull GlobalSearchScope scope, @NotNull StubIndexKey<String, JSImplicitElementProvider> key) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        StubIndex stubIndex = StubIndex.getInstance();
        Project project = scope.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Collection collection = stubIndex.getAllKeys(key, project);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"StubIndex.getInstance().\u2026eys(key, scope.project!!)");
        Collection keys = collection;
        Iterable iterable = $receiver$iv = (Iterable)keys;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Collection<JSImplicitElement> collection2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (VueIndexKt.resolve(string, scope, key) == null) continue;
            Collection<JSImplicitElement> it$iv$iv = collection2;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Collection it = (Collection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.toList((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Collection<JSImplicitElement> resolve(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull StubIndexKey<String, JSImplicitElementProvider> key) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)NAME);
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Project project = scope.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        String normalized = VueIndexKt.normalizeNameForIndex(name);
        String indexKey = VueIndexBase.Companion.createJSKey(key);
        List result = new ArrayList();
        StubIndex stubIndex = StubIndex.getInstance();
        Project project2 = scope.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        stubIndex.processElements(key, (Object)normalized, project2, scope, JSImplicitElementProvider.class, (Processor)new Processor<JSImplicitElementProvider>(indexKey, normalized, result){
            final /* synthetic */ String $indexKey;
            final /* synthetic */ String $normalized;
            final /* synthetic */ List $result;

            /*
             * WARNING - void declaration
             */
            public final boolean process(@Nullable JSImplicitElementProvider provider2) {
                Object object = provider2;
                if (object != null && (object = object.getIndexingData()) != null && (object = object.getImplicitElements()) != null) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv = (Iterable)object;
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        JSImplicitElement it = (JSImplicitElement)element$iv$iv;
                        boolean bl = false;
                        JSImplicitElement jSImplicitElement = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSImplicitElement, (String)"it");
                        if (!(Intrinsics.areEqual((Object)jSImplicitElement.getUserString(), (Object)this.$indexKey) && Intrinsics.areEqual((Object)this.$normalized, (Object)it.getName()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    for (E element$iv : $receiver$iv) {
                        JSImplicitElement it = (JSImplicitElement)element$iv;
                        boolean bl = false;
                        JSImplicitElement jSImplicitElement = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSImplicitElement, (String)"it");
                        this.$result.add(jSImplicitElement);
                    }
                }
                return true;
            }
            {
                this.$indexKey = string;
                this.$normalized = string2;
                this.$result = list;
            }
        });
        return result.isEmpty() ? null : (Collection)result;
    }

    public static final boolean hasVue(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (DumbService.isDumb((Project)project)) {
            return false;
        }
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Boolean>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final CachedValueProvider.Result<Boolean> compute() {
                CachedValueProvider.Result result;
                boolean hasVue2 = false;
                VirtualFile packageJson = null;
                if (this.$project.getBaseDir() != null && (packageJson = this.$project.getBaseDir().findChild("package.json")) != null) {
                    PackageJsonData packageJsonData = PackageJsonData.getOrCreate((VirtualFile)packageJson);
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageJsonData, (String)"PackageJsonData.getOrCreate(packageJson)");
                    PackageJsonData packageJsonData2 = packageJsonData;
                    if (packageJsonData2.isDependencyOfAnyType("vue")) {
                        hasVue2 = true;
                    }
                }
                if (hasVue2) {
                    result = CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{packageJson});
                } else {
                    boolean result2 = FileTypeIndex.containsFileOfType((FileType)((FileType)VueFileType.Companion.getINSTANCE()), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.$project));
                    result = CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootModificationTracker.getInstance((Project)this.$project)});
                }
                return result;
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getM\u2026tance(project))\n    }\n  }");
        return (Boolean)object;
    }

    public static final boolean hasVueClassComponentLibrary(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (DumbService.isDumb((Project)project)) {
            return false;
        }
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Boolean>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final CachedValueProvider.Result<Boolean> compute() {
                boolean recordedDependency;
                Collection packageJsonFiles;
                block9: {
                    boolean bl;
                    Collection collection = FilenameIndex.getVirtualFilesByName((Project)this.$project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.$project));
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FilenameIndex.getVirtual\u2026pe.projectScope(project))");
                    packageJsonFiles = collection;
                    Iterable $receiver$iv = packageJsonFiles;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            VirtualFile it = (VirtualFile)element$iv;
                            boolean bl2 = false;
                            if (!PackageJsonUtil.getOrCreateData((VirtualFile)it).isDependencyOfAnyType("vue-class-component")) continue;
                            bl = true;
                            break block9;
                        }
                        bl = recordedDependency = false;
                    }
                }
                if (!recordedDependency) {
                    boolean bl;
                    block10: {
                        PsiManager psiManager = PsiManager.getInstance((Project)this.$project);
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
                        PsiManager psiManager2 = psiManager;
                        Iterable $receiver$iv = packageJsonFiles;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                boolean bl3;
                                VirtualFile it = (VirtualFile)element$iv;
                                boolean bl4 = false;
                                if (psiManager2.findFile(it) == null) {
                                    bl3 = false;
                                } else {
                                    PsiFile psiFile;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"psiManager.findFile(it) ?: return@any false");
                                    bl3 = NodePackageUtil.hasAnyOfPluginsInstalled((PsiFile)psiFile, (List)CollectionsKt.listOf((Object)"vue-class-component"));
                                }
                                if (!bl3) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    recordedDependency = bl;
                }
                return new CachedValueProvider.Result((Object)recordedDependency, new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootModificationTracker.getInstance((Project)this.$project)});
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getM\u2026etInstance(project))\n  })");
        return (Boolean)object;
    }

    public static final boolean isGlobal(@NotNull JSImplicitElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return VueIndexKt.getVueIndexData(element).isGlobal();
    }

    public static final boolean isGlobalExact(@NotNull JSImplicitElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return VueIndexKt.getVueIndexData(element).isGlobalExact();
    }

    @NotNull
    public static final JSImplicitElementImpl createImplicitElement(@NotNull String name, @NotNull PsiElement provider2, @NotNull String indexKey, @Nullable String nameType, @Nullable PsiElement descriptor, boolean isGlobal) {
        Object descriptorRef;
        Object object;
        JSIndexedPropertyAccessExpression asIndexed;
        Object object2;
        PsiElement psiElement;
        String nameTypeRecord;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)NAME);
        Intrinsics.checkParameterIsNotNull((Object)provider2, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)indexKey, (String)"indexKey");
        String normalized = VueIndexKt.normalizeNameForIndex(name);
        String string = nameType;
        if (string == null) {
            string = nameTypeRecord = "";
        }
        if (!((psiElement = descriptor) instanceof JSIndexedPropertyAccessExpression)) {
            psiElement = null;
        }
        if ((object2 = (asIndexed = (JSIndexedPropertyAccessExpression)psiElement)) == null || (object2 = object2.getQualifier()) == null || (object2 = object2.getText()) == null) {
            PsiElement psiElement2 = descriptor;
            if (!(psiElement2 instanceof JSReferenceExpression)) {
                psiElement2 = null;
            }
            JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)psiElement2;
            object2 = object = jSReferenceExpression != null ? jSReferenceExpression.getText() : null;
        }
        if (object2 == null) {
            object = descriptorRef = "";
        }
        if (asIndexed != null) {
            descriptorRef = (String)descriptorRef + INDEXED_ACCESS_HINT;
        }
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl.Builder(normalized, provider2).setUserString(indexKey).setTypeString("" + (isGlobal ? 1 : 0) + '#' + nameTypeRecord + '#' + (String)descriptorRef + '#' + name).toImplicitElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)jSImplicitElementImpl, (String)"JSImplicitElementImpl.Bu\u2026\n    .toImplicitElement()");
        return jSImplicitElementImpl;
    }

    @NotNull
    public static /* synthetic */ JSImplicitElementImpl createImplicitElement$default(String string, PsiElement psiElement, String string2, String string3, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            psiElement2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return VueIndexKt.createImplicitElement(string, psiElement, string2, string3, psiElement2, bl);
    }

    private static final String normalizeNameForIndex(String name) {
        return VueUtilKt.fromAsset(StringsKt.substringBeforeLast$default((String)name, (String)GLOBAL_BINDING_MARK, null, (int)2, null));
    }

    @NotNull
    public static final VueIndexData getVueIndexData(@NotNull JSImplicitElement element) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = element.getTypeString();
        if (string == null) {
            String string2 = element.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.name");
            return new VueIndexData(string2, null, null, false, false);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.typeString ?: re\u2026null, null, false, false)");
        String typeStr = string;
        String originalName = StringsKt.substringAfterLast$default((String)typeStr, (String)DELIMITER, null, (int)2, null);
        String s = StringsKt.substringBeforeLast$default((String)typeStr, (String)DELIMITER, null, (int)2, null);
        List parts = StringsKt.split$default((CharSequence)s, (String[])new String[]{DELIMITER}, (boolean)false, (int)0, (int)6, null);
        boolean bl2 = bl = parts.size() == 3;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        boolean isGlobal = Intrinsics.areEqual((Object)"1", (Object)((String)parts.get(0)));
        String nameRef = (String)parts.get(1);
        String descriptor = StringsKt.substringBefore$default((String)((String)parts.get(2)), (String)INDEXED_ACCESS_HINT, null, (int)2, null);
        boolean isIndexed = StringsKt.endsWith$default((String)((String)parts.get(2)), (String)INDEXED_ACCESS_HINT, (boolean)false, (int)2, null);
        return new VueIndexData(originalName, nameRef, descriptor, isIndexed, isGlobal);
    }
}

