/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.language;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSInjectionBracesUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.VueFileType;
import org.jetbrains.vuejs.codeInsight.VueAttributesProvider;
import org.jetbrains.vuejs.codeInsight.VueAttributesProviderKt;
import org.jetbrains.vuejs.codeInsight.VueComponents;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.index.VueIndexKt;
import org.jetbrains.vuejs.index.VueOptionsIndex;
import org.jetbrains.vuejs.language.VueInjector;
import org.jetbrains.vuejs.language.VueJSLanguage;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/vuejs/language/VueInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "()V", "elementsToInjectIn", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "context", "injectInElement", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "Companion", "intellij.vuejs"})
public final class VueInjector
implements MultiHostInjector {
    private static final Set<String> delimitersOptionHolders;
    @NotNull
    private static final NullableFunction<PsiElement, Pair<String, String>> BRACES_FACTORY;
    public static final Companion Companion;

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        CharSequence charSequence;
        FileType fileType;
        Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
        Project project2 = project;
        if (!VueIndexKt.hasVue(project2)) {
            return;
        }
        PsiFile psiFile = context.getContainingFile();
        FileType fileType2 = psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getFileType() : (fileType = null);
        if (Intrinsics.areEqual(fileType, (Object)HtmlFileType.INSTANCE) ^ true && Intrinsics.areEqual((Object)fileType, (Object)((Object)VueFileType.Companion.getINSTANCE())) ^ true) {
            return;
        }
        if (context instanceof XmlAttributeValueImpl && !((charSequence = (CharSequence)((XmlAttributeValueImpl)context).getValue()) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((XmlAttributeValueImpl)context).getParent() instanceof XmlAttribute) {
            PsiElement psiElement = ((XmlAttributeValueImpl)context).getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.xml.XmlAttribute");
            }
            String string = ((XmlAttribute)psiElement).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(context.parent as XmlAttribute).name");
            if (VueAttributesProvider.Companion.isInjectJS(string)) {
                JSEmbeddedContent embedded = (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)context, JSEmbeddedContent.class);
                if (embedded != null && Intrinsics.areEqual((Object)((Object)VueJSLanguage.Companion.getINSTANCE()), (Object)embedded.getLanguage()) ^ true) {
                    JSLiteralExpressionImpl literal = (JSLiteralExpressionImpl)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)embedded), JSLiteralExpressionImpl.class);
                    if (literal != null) {
                        this.injectInElement((PsiLanguageInjectionHost)literal, registrar);
                        return;
                    }
                } else if (embedded == null) {
                    this.injectInElement((PsiLanguageInjectionHost)context, registrar);
                }
            }
        }
        if (context instanceof XmlTextImpl || context instanceof XmlAttributeValueImpl) {
            Pair pair = (Pair)BRACES_FACTORY.fun((Object)context);
            if (pair == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"BRACES_FACTORY.`fun`(context) ?: return");
            Pair braces = pair;
            JSInjectionBracesUtil.injectInXmlTextByDelimiters((MultiHostRegistrar)registrar, (PsiElement)context, (Language)((Language)VueJSLanguage.Companion.getINSTANCE()), (String)((String)braces.getFirst()), (String)((String)braces.getSecond()));
        }
    }

    private final void injectInElement(PsiLanguageInjectionHost host, MultiHostRegistrar registrar) {
        registrar.startInjecting((Language)VueJSLanguage.Companion.getINSTANCE()).addPlace(null, null, host, ElementManipulators.getValueTextRange((PsiElement)((PsiElement)host))).doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlTextImpl.class, XmlAttributeValueImpl.class);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList<Class<out \u2026uteValueImpl::class.java)");
        return list;
    }

    static {
        Companion = new Companion(null);
        delimitersOptionHolders = SetsKt.setOf((Object[])new String[]{"Vue.config.delimiters", "Vue.options.delimiters"});
        NullableFunction nullableFunction = JSInjectionBracesUtil.delimitersFactory((String)VueJSLanguage.Companion.getINSTANCE().getDisplayName(), (PairFunction)Companion.BRACES_FACTORY.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)nullableFunction, (String)"JSInjectionBracesUtil.de\u2026ment(project, key)\n    })");
        BRACES_FACTORY = nullableFunction;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R)\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/vuejs/language/VueInjector$Companion;", "", "()V", "BRACES_FACTORY", "Lcom/intellij/util/NullableFunction;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/Pair;", "", "getBRACES_FACTORY", "()Lcom/intellij/util/NullableFunction;", "delimitersOptionHolders", "", "calculateDelimitersFromAssignment", "project", "Lcom/intellij/openapi/project/Project;", "key", "calculateDelimitersFromIndex", "getDelimiterValue", "holder", "intellij.vuejs"})
    public static final class Companion {
        @NotNull
        public final NullableFunction<PsiElement, Pair<String, String>> getBRACES_FACTORY() {
            return BRACES_FACTORY;
        }

        private final Pair<String, PsiElement> calculateDelimitersFromIndex(Project project, String key) {
            JSObjectLiteralExpression jSObjectLiteralExpression;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
            Collection<JSImplicitElement> collection = VueIndexKt.resolve("", globalSearchScope, VueOptionsIndex.Companion.getKEY());
            if (collection == null) {
                return null;
            }
            Collection<JSImplicitElement> elements = collection;
            JSImplicitElement jSImplicitElement = (JSImplicitElement)CollectionsKt.firstOrNull(VueComponents.Companion.onlyLocal(elements));
            if (jSImplicitElement == null) {
                return null;
            }
            JSImplicitElement element = jSImplicitElement;
            JSImplicitElement jSImplicitElement2 = element;
            if (!(jSImplicitElement2 instanceof JSObjectLiteralExpression)) {
                jSImplicitElement2 = null;
            }
            if ((jSObjectLiteralExpression = (JSObjectLiteralExpression)jSImplicitElement2) == null) {
                jSObjectLiteralExpression = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), JSObjectLiteralExpression.class);
            }
            if (jSObjectLiteralExpression == null) {
                return null;
            }
            JSObjectLiteralExpression obj = jSObjectLiteralExpression;
            JSProperty jSProperty = VueAttributesProviderKt.findProperty(obj, "delimiters");
            if (jSProperty == null) {
                return null;
            }
            JSProperty property = jSProperty;
            String string = this.getDelimiterValue((PsiElement)property, key);
            if (string == null) {
                return null;
            }
            String delimiter = string;
            return Pair.create((Object)delimiter, (Object)element);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<String, PsiElement> calculateDelimitersFromAssignment(Project project, String key) {
            Object $receiver$iv$iv;
            NavigationItem[] navigationItemArray = JavaScriptIndex.getInstance((Project)project).getSymbolsByName("delimiters", false);
            Intrinsics.checkExpressionValueIsNotNull((Object)navigationItemArray, (String)"JavaScriptIndex.getInsta\u2026Name(\"delimiters\", false)");
            NavigationItem[] delimitersDefinitions = navigationItemArray;
            Object $receiver$iv = delimitersDefinitions;
            NavigationItem[] navigationItemArray2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv;
            int n = ((void)iterator).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = iterator[i];
                boolean bl = false;
                if (!(it instanceof JSDefinitionExpression && ((PsiElement)it).getContext() != null && CollectionsKt.contains((Iterable)delimitersOptionHolders, (Object)((JSDefinitionExpression)it).getQualifiedName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            if (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                NavigationItem navigationItem = (NavigationItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                }
                PsiElement psiElement = ((PsiElement)v1).getContext();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"(it as PsiElement).context!!");
                String delimiter = Companion.getDelimiterValue(psiElement, key);
                if (delimiter != null) {
                    return Pair.create((Object)delimiter, (Object)it);
                }
                return null;
            }
            return (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        private final String getDelimiterValue(PsiElement holder, String key) {
            List<JSLiteralExpression> list = VueUtilKt.getStringLiteralsFromInitializerArray(holder, VueUtilKt.getEMPTY_FILTER());
            if (list.size() != 2) {
                return null;
            }
            JSLiteralExpression jSLiteralExpression = list.get(Intrinsics.areEqual((Object)"startSymbol", (Object)key) ? 0 : 1);
            if (!(jSLiteralExpression instanceof JSLiteralExpression)) {
                jSLiteralExpression = null;
            }
            if (jSLiteralExpression == null) {
                return null;
            }
            JSLiteralExpression literal = jSLiteralExpression;
            String string = literal.getSignificantValue();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"literal.significantValue!!");
            return VueUtilKt.es6Unquote(string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Pair access$calculateDelimitersFromIndex(Companion $this, Project project, String key) {
            return $this.calculateDelimitersFromIndex(project, key);
        }

        public static final /* synthetic */ Pair access$calculateDelimitersFromAssignment(Companion $this, Project project, String key) {
            return $this.calculateDelimitersFromAssignment(project, key);
        }
    }
}

