/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.typescript.service;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueFileType;
import org.jetbrains.vuejs.typescript.service.VueTypeScriptService;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/vuejs/typescript/service/VueLanguageServiceProvider;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myLanguageService", "Lcom/intellij/openapi/util/AtomicNotNullLazyValue;", "Lorg/jetbrains/vuejs/typescript/service/VueTypeScriptService;", "getAllServices", "", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "getService", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCandidate", "", "intellij.vuejs"})
public final class VueLanguageServiceProvider
implements JSLanguageServiceProvider {
    private final AtomicNotNullLazyValue<VueTypeScriptService> myLanguageService;

    @NotNull
    public List<JSLanguageService> getAllServices() {
        Object object = this.myLanguageService.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"myLanguageService.value");
        VueTypeScriptService value = (VueTypeScriptService)((Object)object);
        return CollectionsKt.listOf((Object)((Object)value));
    }

    @Nullable
    public JSLanguageService getService(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = this.myLanguageService.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"myLanguageService.value");
        VueTypeScriptService value = (VueTypeScriptService)((Object)object);
        return value.isAcceptable(file) ? (JSLanguageService)value : null;
    }

    public boolean isCandidate(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        FileType fileType = file.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"file.fileType");
        FileType type = fileType;
        return TypeScriptLanguageServiceProvider.isJavaScriptOrTypeScriptFileType((FileType)type) || Intrinsics.areEqual((Object)type, (Object)((Object)VueFileType.Companion.getINSTANCE()));
    }

    public VueLanguageServiceProvider(final @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AtomicNotNullLazyValue atomicNotNullLazyValue = AtomicNotNullLazyValue.createValue((NotNullFactory)new NotNullFactory<T>(){

            @NotNull
            public final VueTypeScriptService create() {
                TypeScriptCompilerSettings typeScriptCompilerSettings = TypeScriptCompilerSettings.getSettings((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeScriptCompilerSettings, (String)"TypeScriptCompilerSettings.getSettings(project)");
                VueTypeScriptService service = new VueTypeScriptService(project, typeScriptCompilerSettings);
                Disposer.register((Disposable)((Disposable)project), (Disposable)((Disposable)service));
                return service;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)atomicNotNullLazyValue, (String)"AtomicNotNullLazyValue.c\u2026createValue service\n    }");
        this.myLanguageService = atomicNotNullLazyValue;
    }
}

