/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.typescript.service;

import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigureRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigureRequestArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.FileExtensionInfo;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueFileType;
import org.jetbrains.vuejs.index.VueIndexKt;
import org.jetbrains.vuejs.typescript.service.VueTypeScriptService;
import org.jetbrains.vuejs.typescript.service.VueTypeScriptServiceKt;
import org.jetbrains.vuejs.typescript.service.protocol.VueTypeScriptServiceProtocol;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u001a\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0 H\u0014J\b\u0010!\u001a\u00020\u0018H\u0014J \u0010\"\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0014J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u001aH\u0016J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u001aH\u0002J\b\u0010)\u001a\u00020\u000fH\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/vuejs/typescript/service/VueTypeScriptService;", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;)V", "addConfigureCommand", "", "result", "", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "Lcom/intellij/util/Consumer;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "canHighlight", "", "file", "Lcom/intellij/psi/PsiFile;", "createLSCache", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl;", "createProtocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "readyConsumer", "tsServicePath", "", "getDocumentText", "Lcom/intellij/openapi/vfs/VirtualFile;", "instance", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "document", "Lcom/intellij/openapi/editor/Document;", "getInitialCommands", "", "getProcessName", "isAcceptableNonTsFile", "service", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfigService;", "virtualFile", "isServiceEnabled", "context", "isVueFile", "isVueServiceEnabled", "intellij.vuejs"})
public final class VueTypeScriptService
extends TypeScriptServerServiceImpl {
    protected boolean isAcceptableNonTsFile(@NotNull Project project, @NotNull TypeScriptConfigService service, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        if (super.isAcceptableNonTsFile(project, service, virtualFile)) {
            return true;
        }
        if (!this.isVueFile(virtualFile)) {
            return false;
        }
        return service.getPreferableConfig(virtualFile) != null;
    }

    @NotNull
    protected String getProcessName() {
        return "Vue TypeScript";
    }

    public boolean isServiceEnabled(@NotNull VirtualFile context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return super.isServiceEnabled(context) && this.isVueServiceEnabled();
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(@NotNull Consumer<?> readyConsumer, @NotNull String tsServicePath) {
        Intrinsics.checkParameterIsNotNull(readyConsumer, (String)"readyConsumer");
        Intrinsics.checkParameterIsNotNull((Object)tsServicePath, (String)"tsServicePath");
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        TypeScriptCompilerSettings typeScriptCompilerSettings = this.mySettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeScriptCompilerSettings, (String)"mySettings");
        Consumer consumer = this.createEventConsumer();
        Intrinsics.checkExpressionValueIsNotNull((Object)consumer, (String)"createEventConsumer()");
        return (JSLanguageServiceProtocol)new VueTypeScriptServiceProtocol(project, typeScriptCompilerSettings, readyConsumer, (Consumer<? super JSLanguageServiceAnswer>)consumer, tsServicePath);
    }

    private final boolean isVueServiceEnabled() {
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        return VueIndexKt.hasVue(project);
    }

    @NotNull
    protected Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> getInitialCommands() {
        Map map = super.getInitialCommands();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"super.getInitialCommands()");
        Map initialCommands = map;
        LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashMap, (String)"ContainerUtil.newLinkedHashMap()");
        Map result = linkedHashMap;
        this.addConfigureCommand(result);
        result.putAll(initialCommands);
        return result;
    }

    public boolean canHighlight(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (super.canHighlight(file)) {
            return true;
        }
        FileType fileType = file.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"file.fileType");
        FileType fileType2 = fileType;
        if (Intrinsics.areEqual((Object)fileType2, (Object)((Object)VueFileType.Companion.getINSTANCE())) ^ true) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!this.isServiceEnabled(virtualFile2)) {
            return false;
        }
        String configForFile = this.getConfigForFile(virtualFile2);
        return configForFile != null;
    }

    private final void addConfigureCommand(Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> result) {
        ConfigureRequestArguments arguments = new ConfigureRequestArguments();
        FileExtensionInfo fileExtensionInfo = new FileExtensionInfo();
        fileExtensionInfo.setExtension(".vue");
        arguments.setExtraFileExtensions(new FileExtensionInfo[]{fileExtensionInfo});
        Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> map = result;
        ConfigureRequest configureRequest = new ConfigureRequest(arguments);
        addConfigureCommand.1 var6_6 = addConfigureCommand.1.INSTANCE;
        map.put((JSLanguageServiceSimpleCommand)configureRequest, var6_6);
    }

    @NotNull
    protected TypeScriptLanguageServiceCacheImpl createLSCache() {
        return new TypeScriptLanguageServiceCacheImpl(this, this.myProject){
            final /* synthetic */ VueTypeScriptService this$0;

            @NotNull
            protected String getDocumentText(@NotNull VirtualFile virtualFile, @NotNull Document document) {
                Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                if (!VueTypeScriptService.access$isVueFile(this.this$0, virtualFile)) {
                    String string = super.getDocumentText(virtualFile, document);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.getDocumentText(virtualFile, document)");
                    return string;
                }
                Project project = VueTypeScriptService.access$getMyProject$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                String string = VueTypeScriptServiceKt.getModifiedVueDocumentText(project, document);
                if (string == null) {
                    string = "";
                }
                return string;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
    }

    @Nullable
    protected String getDocumentText(@NotNull VirtualFile file, @NotNull FileDocumentManager instance, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (!this.isVueFile(file)) {
            return super.getDocumentText(file, instance, document);
        }
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        return VueTypeScriptServiceKt.getModifiedVueDocumentText(project, document);
    }

    private final boolean isVueFile(VirtualFile virtualFile) {
        return Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)((Object)VueFileType.Companion.getINSTANCE()));
    }

    public VueTypeScriptService(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super(project, settings, "Vue Console");
    }

    public static final /* synthetic */ boolean access$isVueFile(VueTypeScriptService $this, VirtualFile virtualFile) {
        return $this.isVueFile(virtualFile);
    }

    public static final /* synthetic */ Project access$getMyProject$p(VueTypeScriptService $this) {
        return $this.myProject;
    }
}

