/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.typescript.service;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueFrameworkHandlerKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"getModifiedVueDocumentText", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.vuejs"})
public final class VueTypeScriptServiceKt {
    @Nullable
    public static final String getModifiedVueDocumentText(@NotNull Project project, @NotNull Document document) {
        boolean bl;
        TextRange textRange;
        ASTNode text;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        JSEmbeddedContent jSEmbeddedContent = VueFrameworkHandlerKt.findModule((PsiElement)psiFile);
        if (jSEmbeddedContent == null) {
            return null;
        }
        JSEmbeddedContent module = jSEmbeddedContent;
        ASTNode aSTNode = text = module.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"text");
        TextRange textRange2 = textRange = aSTNode.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"textRange");
        int lineNumber = document.getLineNumber(textRange2.getStartOffset());
        String string = StringUtil.repeat((String)"\n", (int)lineNumber);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.repeat(\"\\n\", lineNumber)");
        String newLines = string;
        int currentLineStart = textRange.getStartOffset() - document.getLineStartOffset(lineNumber);
        if (currentLineStart < 0) {
            return null;
        }
        String string2 = StringUtil.repeat((String)" ", (int)currentLineStart);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.repeat(\" \", currentLineStart)");
        String spacesCurrentLine = string2;
        int startSpaceCount = textRange.getStartOffset() - newLines.length() - currentLineStart;
        if (startSpaceCount < 0) {
            return null;
        }
        String string3 = StringUtil.repeat((String)" ", (int)startSpaceCount);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringUtil.repeat(\" \", startSpaceCount)");
        String fakeBefore = string3;
        int afterSpaces = document.getTextLength() - textRange.getEndOffset() - 1;
        if (afterSpaces < 0) {
            return null;
        }
        String string4 = StringUtil.repeat((String)" ", (int)afterSpaces);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringUtil.repeat(\" \", afterSpaces)");
        String fakeAfter = string4;
        String result = fakeBefore + newLines + spacesCurrentLine + text.getText() + "\n" + fakeAfter;
        boolean bl2 = bl = result.length() == document.getTextLength();
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string5));
        }
        return result;
    }
}

